/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.buying.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 抢购产品Entity
 * @author 柴雪腾
 * @version 2017-11-20
 */
public class Advertisement extends DataEntity<Advertisement> {
	
	private static final long serialVersionUID = 1L;
	private String pageName;		// 页面(一级标题)
	private String productName;		// 产品名称(二级标题)
	private String serviceCycle;		// 服务周期
	private String chargingItemId;		// 收费项id
	private String chargingItemName;		// 收费项名称
	private Date saleStartTime;		// 开售时间
	private String pageItem;		// 页面项
	private Date validStartTime;		// 有效开始时间
	private Date validEndTime;		// 有效结束时间
	private String productDetail;		// 产品详情
	private String expectCount;		// 预计总数量
	private String mostCount;		// 最多数量
	private String version; //版本
	public Advertisement() {
		super();
	}

	public Advertisement(String id){
		super(id);
	}

	@Length(min=1, max=100, message="页面(一级标题)长度必须介于 1 和 100 之间")
	public String getPageName() {
		return pageName;
	}

	public void setPageName(String pageName) {
		this.pageName = pageName;
	}
	
	@Length(min=1, max=150, message="产品名称(二级标题)长度必须介于 1 和 150 之间")
	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}
	
	@Length(min=1, max=15, message="服务周期长度必须介于 1 和 15 之间")
	public String getServiceCycle() {
		return serviceCycle;
	}

	public void setServiceCycle(String serviceCycle) {
		this.serviceCycle = serviceCycle;
	}
	
	@Length(min=0, max=64, message="收费项id长度必须介于 0 和 64 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}
	
	@Length(min=0, max=200, message="收费项名称长度必须介于 0 和 200 之间")
	public String getChargingItemName() {
		return chargingItemName;
	}

	public void setChargingItemName(String chargingItemName) {
		this.chargingItemName = chargingItemName;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getSaleStartTime() {
		return saleStartTime;
	}

	public void setSaleStartTime(Date saleStartTime) {
		this.saleStartTime = saleStartTime;
	}
	
	@Length(min=0, max=100, message="页面项长度必须介于 0 和 100 之间")
	public String getPageItem() {
		return pageItem;
	}

	public void setPageItem(String pageItem) {
		this.pageItem = pageItem;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getValidStartTime() {
		return validStartTime;
	}

	public void setValidStartTime(Date validStartTime) {
		this.validStartTime = validStartTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getValidEndTime() {
		return validEndTime;
	}

	public void setValidEndTime(Date validEndTime) {
		this.validEndTime = validEndTime;
	}
	
	public String getProductDetail() {
		return productDetail;
	}

	public void setProductDetail(String productDetail) {
		this.productDetail = productDetail;
	}
	
	@Length(min=0, max=11, message="预计总数量长度必须介于 0 和 11 之间")
	public String getExpectCount() {
		return expectCount;
	}

	public void setExpectCount(String expectCount) {
		this.expectCount = expectCount;
	}
	
	@Length(min=0, max=11, message="最多数量长度必须介于 0 和 11 之间")
	public String getMostCount() {
		return mostCount;
	}

	public void setMostCount(String mostCount) {
		this.mostCount = mostCount;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}
	
	
}