package com.cku.geneTree.utils;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.geneTree.vo.response.SamplingGeneticDiseaseResponse;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.cku.util.JSONUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.config.Global;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @author yuanshuai
 * @since 2024/4/18 11:22
 */
public class GeneTreeReportUtils {

	/**
	 * 根据采样包编号列表获取检测结果
	 *
	 * @author yuanshuai
	 * @since 2024/4/18 11:30
	 */
	public static List<SamplingGeneticDiseaseResponse> findGeneticDiseaseBySamplingCodeList(List<String> samplingCodeList) {
		try {
			String url = Global.getConfig("geneTreeUrl") + "/foreign/report/geneticDisease/samplingCode";
			Map<String, List<String>> jsonMap = Maps.newHashMap();
			jsonMap.put("idList", samplingCodeList);
			HttpResult httpResult = HttpClientUtil.post(null, GeneTreeHttpSignUtils.commonSignUrl(url), "application/json", JSONUtils.toJSON(jsonMap));
			if (StringUtils.isBlank(httpResult.getResponseBody())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请求失败");
			}
			JSONObject resultJson = JSONObject.fromObject(httpResult.getResponseBody());
			String code = resultJson.getString("code");
			if (!"K-000000".equals(code)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, resultJson.getString("message"));
			}
			//获取相应list
			JSONArray jArray = resultJson.getJSONArray("data");
			List<SamplingGeneticDiseaseResponse> syncList = Lists.newArrayList();
			for (int i = 0; i < jArray.size(); ++i) {
				JSONObject jo = jArray.getJSONObject(i);
				syncList.add(SamplingGeneticDiseaseResponse.builder()
						.samplingCode(jo.getString("samplingCode"))
						.geneticDiseaseJson(jo.getString("geneticDisease"))
						.build());
			}
			return syncList;
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "没有请求到遗传疾病信息:" + e.getMessage());
		}
	}

}
