//个人美容师活动报名申请列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //活动地点
        me.showAddress = ko.observable("");
        //计时器
        me.timeRun = null;
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        // 活动类型：比赛match；讲座cathedra；考试exam
        me.showType = ko.observable("");
        //活动类型文本
        me.showText = ko.observable("全部");
        //活动名称
        me.showName = ko.observable("");
        //活动类型默认隐藏
        me.isShouldShow = ko.observable(false);
        //活动类型的显隐藏
        me.isShow = function(){
            me.isShouldShow(!me.isShouldShow())
        }
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findgroomerShowList(false);
        }
        //下一页
        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findgroomerShowList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findgroomerShowList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findgroomerShowList(false);
            }
            return false;
        }
        //活动类型的选择
        me.witchType = function(type){
            $("#activityType li").removeAttr("class");
            $("#"+type).attr("class","active");
            type=='all'?me.showType(""):me.showType(type);
            var typeText = $("#"+type).children("a").text();
            me.showText(typeText);
            me.isShouldShow(!me.isShouldShow());
        }
        //说明 须知 简章 附件的打开关闭
        me.description = function(data,event){
            if($(event.target).siblings(".pop").css("display")=="none"){
                $(event.target).siblings(".pop").css("display","block");
            }else{
                $(event.target).siblings(".pop").css("display","none");
            }
        }
        me.closeDescription = function(data,event){
            $(event.target).parents(".pop").css("display","none");
        }
        /**
         * 美容师活动列表查询方法
         */
        me.findPgroomerShowList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["showAddress"] = me.showAddress().trim();
            sendData["showType"] = me.showType();
            sendData["showName"] = me.showName().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'groomer/groomerShow',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length>0) {
                            var list = data.list;
                            $.each(list, function (index, item) {
                                var durTime = new Date(new Date(util.formatDateLong(item.registerEndTime).replace(/-/g,"/"))).getTime() - new Date().getTime();
                                var showTime = util.endTime(durTime);
                                item["showDurTime"] = ko.observable(showTime);
                            });
                            me.listData(list);
                        }else{
                            me.listData([]);
                            layer.msg("美容师活动列表为空！");
                        }
                        me.timeRun = setInterval(me.setTime,10000);
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //报名跳转
        me.register = function(data){
            var id = data.id;
            var showType = data.showType;
            var show_code = data.showCode;
            var sendData = {};
            sendData["show_code"] = show_code;
            util.sendAjax({
                url:'groomer/apply',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        var showLevel = data.data.showLevel;
                        var schoolNameCn = data.data.schoolNameCn;
                        location.href = location.href.split("#")[0]+"#/qualification/p_groomerRegister?showCode="+encodeURIComponent(show_code)+"&showType="+encodeURIComponent(showType)+"&showLevel="+encodeURIComponent(showLevel)+"&schoolNameCn="+encodeURIComponent(schoolNameCn);
                    }else{
                        layer.msg("报名失败:"+data.msg);
                    }
                }
            });
        }
        //截止日期
        me.setTime = function(){
            var list = me.listData();
            $.each(list,function(index,item){
                var durTime = new Date(new Date(util.formatDateLong(item.registerEndTime).replace(/-/g,"/"))).getTime()-new Date().getTime();
                var showTime = util.endTime(durTime);
                item.showDurTime(showTime);
            })
            me.listData(list);
        }
        $(function(){
            me.findPgroomerShowList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
