//冠军登录列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findnewdogchipList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findnewdogchipList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findnewdogchipList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findnewdogchipList(false);
            }
            return false;
        }
        /**
         * 配种证明列表查询方法
         */
        me.findchampionloginList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'show/championlogin',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("冠军登录列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        $(function(){
            me.findchampionloginList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});