//出口证书添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        //出口国家
        me.exportCountry=ko.observable();
        //接收人
        me.exporter= ko.observable();
        //出口目的地
        me.exportDestination = ko.observable();
        //血统证书号
        me.pedigreeCertifiedCode = ko.observable("");
        //根据血统证书号查出来的狗信息
        me.mydog = ko.observable({});
        //获取价格
        me.showPrice = ko.observable("0");
        /**
         * 血统证书列表查询方法
         */
        me.getDog = function(){
            if(me.pedigreeCertifiedCode()==""){
                layer.msg("血统证书号不能为空！");
            }else{
                var sendData = {};
                sendData["pedigreeCertifiedCode"] = me.pedigreeCertifiedCode();
                util.sendAjax({
                    url:'dog/dog',
                    data:sendData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            if(json.list!=null && json.list.length>0){
                                me.mydog(json.list[0]);
                                var id = me.mydog().id;
                                me.getPrice(id);
                            }else{
                                layer.msg("该犬只不在您名下，无法办理此业务!");
                                me.mydog({});
                                me.showPrice("0");
                            }
                        }else{
                            layer.msg("信息查询失败:"+json.msg);
                            me.mydog({});
                            me.showPrice("0");
                        }
                    }
                });
            }
        }
        //获取价格
        me.getPrice = function(id){
            var sendData = {};
            sendData["dogId"] = id;
            util.sendAjax({
                url:'dog/dogexport/getPrice',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.showPrice(json.data.price);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }
                }
            });
        }
        /**
         * 保存
         */
        me.saveCart = function(){
            var id = me.mydog().id;
            if(util.isVal(id)==""){
                layer.msg("请先查询证书信息后提交！");
                return;
            }
            var exportCountry = me.exportCountry();
            if(util.isVal(exportCountry)=="" ||!util.isEnWord(exportCountry.trim())){
                layer.msg("出口国家仅限英文名称！");
                return;
            }
            var exporter = me.exporter();
            if(util.isVal(exporter)=="" ||!util.isEnWord(exporter.trim())){
                layer.msg("接收人仅限英文名称！");
                return;
            }
            var exportDestination = me.exportDestination();
            if(util.isVal(exportDestination)=="" ||!util.isEnNumAddress(exportDestination.trim())){
                layer.msg("联系地址仅限英文和数字名称！");
                return;
            }
            var getKennel = userInfo.getKennel();
            if(getKennel.type!="year"){
                var sendData = {};
                sendData["dogId"] = me.mydog().id;
                sendData["exportCountry"] = me.exportCountry().trim();
                sendData["exporter"] = me.exporter().trim();
                sendData["exportDestination"] = me.exportDestination().trim();
                util.sendAjax({
                    url: 'dog/dogexport',
                    data: JSON.stringify(sendData),
                    async: true,
                    loadFlag: true,
                    type: 'POST',
                    cache: false,
                    success: function (json) {
                        if (json.rc == 0) {
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                , btn: ['跳转', '取消']
                                , yes: function (index) {
                                    layer.close(index);
                                    location.href = location.href.split("#")[0] + "#/order/check";
                                }
                            });
                        } else {
                            layer.msg("出口证书申请失败:" + json.msg);
                        }
                    }
                });
            }else {
                layer.msg("您不是永久犬舍，不能申请此业务！");
            }
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});

