<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容课程管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">美容课程列表</a></li>
		<li class=""><a href="${ctxSchools}/schoolsCourse/viewApply">课程报名</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerCourse" action="${ctxSchools}/schoolsCourse/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>课程名：</label>
				<form:input path="courseName" htmlEscape="false"  class="input-medium"/>
			</li>
			<li><label>课程编号：</label>
				<form:input path="code" htmlEscape="false"  class="input-medium"/>
			</li>
			<li><label>课程状态：</label>
				<form:select path="states" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('course_states')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>添加时间：</label>
				<input name="beginCreateDate"  type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerCourse.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerCourse.endCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns" style="float:right" onclick=""><a class="btn btn-primary" href="${ctxSchools}/schoolsCourse/groomerCourseForm">添加课程</a></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>课程编号</th>
				<th>名称</th>
				<th>封面</th>
				<th>状态</th>
				<th>价格</th>
				<th>类型</th>
				<th>级别</th>
				<th>创建时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerCourse">
			<tr>
				<td>
					${groomerCourse.code}
				</td>
				<td>
					${groomerCourse.courseName}
				</td>
				<td>
					<c:if test='${empty groomerCourse.cover}'>
						--
					</c:if>
					<c:if test='${not empty groomerCourse.cover}'>
						<img  style="width:50px; height: 50px"src="${pageContext.request.contextPath}/api/v1/open/image/${groomerCourse.cover}">
					</c:if>
				</td>
				<td>
					${fns:getDictLabel(groomerCourse.states, 'course_states', '')}
				</td>
				<td>
					${groomerCourse.price}
				</td>
				<td>
					${fns:getDictLabel(groomerCourse.type, 'course_type', '')}
				</td>
				<td>
					${fns:getDictLabel(groomerCourse.diplomaLevel, 'course_level', '')}
				</td>
				<td>
					<fmt:formatDate value="${groomerCourse.createDate}" pattern="yyyy-MM-dd"/>
				</td>

				<td>
					<c:if test='${groomerCourse.type == 3}'>
						未上架
						<a href="${ctxSchools}/schoolsCourse/groomerCourseEditForm?id=${groomerCourse.id}">编辑</a>
					</c:if>
    				<c:if test='${groomerCourse.havaDiploma == "true"}'>
						<c:if test='${groomerCourse.type != 3}'>
							<c:if test='${ groomerCourse.states != 3 && groomerCourse.states != 6 && groomerCourse.states != 5 }'>
								<a href="${ctxSchools}/schoolsCourse/groomerCourseEditForm?id=${groomerCourse.id}">编辑</a>
							</c:if>
							<c:if test='${groomerCourse.states == 1 || groomerCourse.states == 4 || groomerCourse.states == 5 }'>
								<a href="${ctxSchools}/schoolsCourse/onOffStates?id=${groomerCourse.id}">上架</a>
							</c:if>
							<c:if test='${groomerCourse.states == 3 || groomerCourse.states == 2}'>
								<a href="${ctxSchools}/schoolsCourse/onOffStates?id=${groomerCourse.id}">下架</a>
							</c:if>
							<c:if test='${groomerCourse.states == 6 }'>
								下架
							</c:if>
						</c:if>
					</c:if>
					<a href="${ctxSchools}/schoolsCourse/viewApply?courseId=${groomerCourse.id}">报名</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>