<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>地方俱乐部信息统计</title>
<meta name="decorator" content="default" />

<script type="text/javascript">
	$(document).ready(function() {
		$("#btnExport").click(function(){
			top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					$("#searchForm").attr("action","${ctx}/sys/org/exportIncome");
					$("#searchForm").submit();
					$("#searchForm").attr("action","${ctx}/sys/org/income?orgType=club");

				}
			},{buttonsFocus:1});
			top.$('.jbox-body .jbox-icon').css('top','55px');
		});
	});
	function page(n, s) {
		$("#pageNo").val(n);
		$("#pageSize").val(s);
		$("#searchForm").submit();
		return false;
	}
	function SubmitByDate(date) {
		document.getElementById("nowDate").value = date
		document.getElementById("searchForm").submit();
	}
</script>
<style>
th, td {
	text-align: center !important;
	vertical-align: middle !important;
}
</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li  class="active"><a href="#">俱乐部</a></li>
		<li class=""><a href="${ctx}/sys/org/income?orgType=hospital">合作医院</a></li>
		<li class=""><a href="${ctx}/sys/org/income?orgType=catRenZheng">认证中心</a></li>
		<li class=""><a href="${ctx}/sys/org/income?orgType=chongjihemendian">鉴定门店</a></li>
	</ul>
	<form id="searchForm" action="${ctx}/sys/org/income" method="post" class="breadcrumb form-search">
		<ul class="ul-form">
			<li>
				<label>机构名称：</label> <input id="name" name="name" type="text" maxlength="20" class="input " style="width: 163px" 	value="${name}" />
			</li>
			<li>
				<label>机构编号：</label> <input id="memberCode" name="memberCode" type="text" maxlength="20" class="input " style="width: 163px" 	value="${memberCode}" />
			</li>
			<li>
				<label>所属机构：</label>
				<select id="tuijiansren" name="tuijiansren" class="input-small selector" style="width: 177px">
					<option value="">请选择</option>
					<c:forEach items="${orgList}" var="p">
						<option value="${fns:escapeHtml(p.id) }"
								<c:if test="${p.id eq tuijiansren }">
									selected = "selected"
								</c:if>>${fns:escapeHtml(p.name) }
						</option>
					</c:forEach>
				</select>
			</li>
			<li><label>开始时间：</label> <input id="startDate" name="startDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${startDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>

			<li><label>结束时间：</label> <input id="endDate" name="endDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${endDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>
			<li style="padding-left: 72px" class="btns">
				<input id="btnSubmit" class="btn btn-primary" onclick="SubmitByDate('input')" type="submit" value="查询" />
			</li>
			<li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出查询结果"/></li>
			<li><input id="nowDate" type="hidden" name="nowDate" value="" /></li>
			<li><input id="orgType" type="hidden" name="orgType" value="club" /></li>
		</ul>

	</form>
	<sys:message content="${message}" />
	<table id="contentTable"
		class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
                <th rowspan="3">地区</th>
				<th rowspan="3">机构名称</th>
				<th rowspan="3">机构编号</th>
				<th rowspan="3">所属机构</th>
				<th colspan="4">会员业务</th>
				<th colspan="7">繁殖业务</th>
			</tr>
			<tr>
                <th>普卡会员</th>
				<th colspan="1">银卡会员</th>
				<th colspan="1">金卡会员</th>
				<th colspan="1">铂金会员</th>
				<th colspan="1">血统证书</th>
				<th colspan="1">血样留存</th>
				<th colspan="1">DNA存档</th>
				<th colspan="1">整窝办理</th>
				<th colspan="1">纯种鉴定</th>
				<th colspan="1">芯片代打</th>
				<th colspan="1">换发芯片</th>
			</tr>

			<%--<tr>--%>
				<%--<th onclick="orderByName('contentTable',4,'number')"><a href="javascript:;">数量</a></th>--%>

				<%--<th onclick="orderByName('contentTable',5,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',6,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',7,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',8,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',9,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',10,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',11,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',12,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',13,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',14,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',15,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',16,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',17,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',18,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',19,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',20,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',21,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',22,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

				<%--<th onclick="orderByName('contentTable',23,'number')"><a href="javascript:;">数量</a></th>--%>
				<%--&lt;%&ndash;<th onclick="orderByName('contentTable',24,'number')"><a href="javascript:;">金额</a></th>&ndash;%&gt;--%>

			<%--</tr>--%>

		</thead>
		<tbody id="clubContent">
			<c:forEach items="${results}" var="result">
				<tr>
                    <td>${result.area_name}</td>
					<td>${result.name}</td>
					<td>${result.member_code}</td>
					<td>${result.tuijiansren}</td>
					<td><font color="blue">${result.defult_card_count}</font></td>

					<td><font color="blue">${result.silver_card_count}</font></td>
					<%--<td><font color="brown">${result.silver_card_price}</font></td>--%>

					<td><font color="blue">${result.golden_card_count}</font></td>
					<%--<td><font color="brown">${result.golden_card_price}</font></td>--%>

					<td><font color="blue">${result.platinum_card_count}</font></td>
					<%--<td><font color="brown">${result.platinum_card_price}</font></td>--%>

					<td><font color="blue">${result.certified_count}</font></td>
					<%--<td><font color="brown">${result.certified_price}</font>--%>

					<td><font color="blue">${result.blood_count}</font></td>
					<%--<td><font color="brown">${result.blood_price}</font>--%>

					<td><font color="blue">${result.dna_archive_count}</font></td>
				    <%--<td><font color="brown">${result.dna_archive_price}</font></td>--%>

					<td><font color="blue">${result.all_nest_count}</font></td>
					<%--<td><font color="brown">${result.all_nest_price}</font></td>--%>

					<td><font color="blue">${result.appraisal_check_count}</font></td>
					<%--<td><font color="brown">${result.appraisal_check_price}</font></td>--%>

					<td><font color="blue">${result.chip_count}</font></td>
					<%--<td><font color="brown">${result.chip_price}</font></td>--%>

					<td><font color="blue">${result.pedi_change_blood_count}</font></td>
					<%--<td><font color="brown">${result.pedi_change_blood_price}</font></td>--%>

				</tr>

			</c:forEach>
		</tbody>
	</table>
</body>
</html>