<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>单独展犬展成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			//给裁判下拉框赋值
			$('#s2id_referee').find('.select2-chosen').html('${fns:escapeHtml(showResultsDdz.referee)}');
			$("#referee").prepend("<option value='${fns:escapeHtml(showResultsDdz.referee)}' selected='selected'>${fns:escapeHtml(showResultsDdz.referee)}</option>");
			
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/results/showResultsDdz/">单独展犬展成绩列表</a></li>
		<li class="active"><a href="${ctx}/results/showResultsDdz/form?id=${showResultsDdz.id}">单独展犬展成绩<shiro:hasPermission name="results:showResultsDdz:edit">${not empty showResultsDdz.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="results:showResultsDdz:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showResultsDdz" action="${ctx}/results/showResultsDdz/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">秩序号：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.orderCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.pedigreeCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">评价：</label>
			<div class="controls">
					${fns:escapeHtml(showResultsDdz.appraisal)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">CC：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.resultCc)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.remarksCc)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">WD：</label>
			<div class="controls">
				${fns:getDictLabel(showResultsDdz.resultWb, 'show_result_ddz_wb', '')}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BOV：</label>
			<div class="controls">
				${fns:getDictLabel(showResultsDdz.resultBob, 'show_result_ddz_bob', '')}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BISS：</label>
			<div class="controls">
				${fns:getDictLabel(showResultsDdz.resultBiss, 'show_result_ddz_biss', '')}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BOW：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.resultBow)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">本场积分：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.showResult)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">单犬种积分：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.showBreedResult)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬主中文名：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.dogOwnerNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主英文名：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.dogOwnerNameEn)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.dogOwnerMemberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI代码：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.fciCode)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${fns:getDictLabel(showResultsDdz.dogGender, 'dog_gender', '')}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
				${fns:getDictLabel(showResultsDdz.ageGroup, 'show_age_group', '')}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬展编号：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.showCode)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">裁判：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.referee)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">活动区域：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.raceLap)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">修改说明：</label>
			<div class="controls">
				${fns:escapeHtml(showResultsDdz.remarks)}
			</div>
		</div>
		<div style="clear:both;"/>
		
<%-- 		<div class="control-group">
			<label class="control-label">犬只信息表主键：</label>
			<div class="controls">
				<form:input path="dogId" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬展编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判：</label>
			<div class="controls">
				<form:input path="referee" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">其他证书号：</label>
			<div class="controls">
				<form:input path="otherCertified" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动区域：</label>
			<div class="controls">
				<form:input path="raceLap" htmlEscape="false" maxlength="10" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种组：</label>
			<div class="controls">
				<form:input path="dogBreedGroup" htmlEscape="false" maxlength="10" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
				<form:input path="ageGroup" htmlEscape="false" maxlength="2" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬性别：</label>
			<div class="controls">
				<form:input path="dogGender" htmlEscape="false" maxlength="1" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI码：</label>
			<div class="controls">
				<form:input path="fciCode" htmlEscape="false" maxlength="6" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主中文名：</label>
			<div class="controls">
				<form:input path="dogOwnerNameCn" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主英文名：</label>
			<div class="controls">
				<form:input path="dogOwnerNameEn" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				<form:input path="dogOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CC备注：</label>
			<div class="controls">
				<form:input path="remarksCc" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOW项成绩：</label>
			<div class="controls">
				<form:input path="resultBow" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">小组排名：</label>
			<div class="controls">
				<form:input path="rankings" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">formatCode：</label>
			<div class="controls">
				<form:input path="formatcode" htmlEscape="false" maxlength="10" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div> --%>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>