<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/shop/shopGoods/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"导入数据", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/shop/shopGoods/">商品列表</a></li>
		<shiro:hasPermission name="shop:shopGoods:add"><li><a href="${ctx}/shop/shopGoods/form">商品添加</a></li></shiro:hasPermission>
	</ul>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/shop/shopGoods/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<form:form id="searchForm" modelAttribute="shopGoods" action="${ctx}/shop/shopGoods/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>商品编号：</label>
				<form:input path="code" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>商品名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>商品分类：</label>
				<form:select id="" path="classId" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${chassList}" var="item">
						<form:option value="${item.id}" label="${item.name}" htmlEscape="false"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>是否上架：</label>
				<form:select path="isShelves" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li class="btns">
				<input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
				<shiro:hasPermission name="shop:shopGoods:export">
				<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>
				</shiro:hasPermission>
				<shiro:hasPermission name="shop:shopGoods:import">
				<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>
				</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>编号</th>
				<th>产品名称</th>
				<th>分类</th>
				<th>买赠</th>
				<th>返利</th>
				<th>分区</th>
				<th>单价</th>
				<th>上架</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="shopGoods" varStatus="i">
			<tr>
				<td><a href="${ctx}/shop/shopGoods/view?id=${fns:escapeHtml(shopGoods.id)}">
					${fns:escapeHtml(shopGoods.code)}
				</a></td>
				<td>
					${fns:escapeHtml(shopGoods.name)}
				</td>
				<td>
					${fns:escapeHtml(shopGoods.className)}
				</td>
				<td>
					${fns:getDictLabel(shopGoods.buyGifts,'goods_buygifts','无')}

				</td>
				<td>
					${fns:getDictLabel(shopGoods.isRebate,'yes_no','否')}
				</td>
				<td>
					${fns:getDictLabel(shopGoods.isInterval,'yes_no','否')}
				</td>
				<td>
					${fns:escapeHtml(shopGoods.price)}
				</td>
				<td>
					${fns:getDictLabel(shopGoods.isShelves,'yes_no','否')}
				</td>
				<td>
					<shiro:hasPermission name="shop:shopGoods:edit">
    					<a href="${ctx}/shop/shopGoods/form?id=${shopGoods.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="shop:shopGoods:delete">
						<a href="${ctx}/shop/shopGoods/delete?id=${shopGoods.id}" onclick="return confirmx('确认要删除该商品吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>