<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>采样包管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//显示导入错误提示
			var importError = "${importError}";
			var reg = new RegExp("##", "g")
			if (importError != null && importError != '' && typeof importError != 'undefined') {
				alert(importError.replace(reg, "\n"));
			}
		});

		function page(n, s) {
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
			return false;
		}

		function importView() {
			$.jBox($("#importBox").html(), {
				title: "采样包信息导入", buttons: {"关闭": true},
				bottomText: "导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"
			});
		}

		function exportView() {
			top.$.jBox.confirm("确认要导出采样包信息吗？", "系统提示", function (v, h, f) {
				if (v == "ok") {
					$("#searchForm").attr("action", "${ctx}/sampling/sampling/export");
					$("#searchForm").submit();
					$("#searchForm").attr("action", "${ctx}/sampling/sampling/");
				}
			}, {buttonsFocus: 1});
			top.$('.jbox-body .jbox-icon').css('top', '55px');
		}

		function exportDogInfoView() {
			top.$.jBox.confirm("确认要导出犬只信息吗？", "系统提示", function (v, h, f) {
				if (v == "ok") {
					$("#searchForm").attr("action", "${ctx}/sampling/sampling/dogInfo/export");
					$("#searchForm").submit();
					$("#searchForm").attr("action", "${ctx}/sampling/sampling/");
				}
			}, {buttonsFocus: 1});
			top.$('.jbox-body .jbox-icon').css('top', '55px');
		}

		function addForm() {
			parent.layer.open({
				type: 2,
				title: ['采样包添加 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '550px'],
				content: ctx + "/sampling/sampling/addForm",
				end: function () {
					if (parent.isYes) {
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}

		function resultForm(id) {
			parent.layer.open({
				type: 2,
				title: ['采样包上传结果 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '550px'],
				content: ctx + "/sampling/sampling/resultForm?id=" + id,
				end: function () {
					if (parent.isYes) {
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}

		// 全选/取消全选
		let checkFlag = false;
		function allCheck() {
			if (!checkFlag) {
				checkFlag = true;
				$(".checkedId").each(function () {
					$(this).attr("checked", checkFlag);
				});
			} else {
				checkFlag = false;
				$(".checkedId").each(function () {
					$(this).attr("checked", checkFlag);
				});
			}
		}

		function batchSendView() {
			let ids = "";
			$(".checkedId:checked").each(function () {
				ids += $(this).attr("samplingId") + ',';
			});
			if (ids == '') {
				layer.msg("请至少选择一个采样包");
				return false;
			}
			let arr = [];
			$(ids.split(",")).each(function (i, val) {
				arr.push({id:val});
			})
			top.$.jBox.confirm("确认要批量送检采样包吗？","批量送检",function(v,h,f){
				if(v=="ok"){
					$.ajax({
						type: "POST",
						url:"${ctx}/sampling/sampling/batchSend",
						contentType:"application/json",
						dataType:"json",
						data: JSON.stringify(arr),
						async: true,
						error: function(request, textStatus, errorThrown) {
							if(request.status=='403'&&errorThrown=='Forbidden'){
								alert("服务器拒绝您的访问，请查看是否存在此功能操作权限！");
							} else {
								alert("错误代码："+request.status+"，错误描述："+errorThrown);
							}
						},
						success: function (data) {
							if (data.rc == 0) {
								layer.msg(data.data);
								window.location = "${ctx}/sampling/sampling"
							} else {
								layer.msg("错误代码：" + data.rc + "错误信息：" + data.msg);
								parent.isYes = false;
							}
						}
					});
				}
			},{buttonsFocus:1});
			top.$('.jbox-body .jbox-icon').css('top','55px');
		}

	</script>
	<style>
		.form-search .ul-form li label{width:auto}
	</style>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/sampling/sampling/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/sampling/sampling/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sampling/sampling/">采样包列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="sampling" action="${ctx}/sampling/sampling/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>采样包编号：</label>
				<form:input path="samplingCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>犬只编号：</label>
				<form:input path="dogCode" htmlEscape="false" hint="请输入CKU血统证书号/国外证书号/出生纸编号" maxlength="64" class="input-medium"/>
			</li>
			<li><label>芯片号：</label>
				<form:input path="chipCode" htmlEscape="false" hint="请输入犬只芯片号" maxlength="64" class="input-medium"/>
			</li>
			<li><label>归属人姓名/会员号：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="16" class="input-medium"/>
			</li>
			<li><label>绑定人姓名/会员号：</label>
				<form:input path="bindUserName" htmlEscape="false" maxlength="16" class="input-medium"/>
			</li>
			<li><label>采样包状态：</label>
				<form:select path="flowState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('sampling_flow_state_front')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>送检时间：</label>
				<input name="beginSendTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${sampling.beginSendTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endSendTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${sampling.endSendTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>绑定时间：</label>
				<input name="beginBindTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${sampling.beginBindTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endBindTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${sampling.endBindTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="sampling:sampling:add">
			<li class="btns"><button id="addButton" type="button" class="btn btn-info"  onclick="addForm()">添加采样包</button></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="sampling:sampling:send">
			<li class="btns"><button id="batchSend" type="button" class="btn btn-warning" onclick="batchSendView()">批量送检</button></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="sampling:sampling:import">
			<li class="btns"><button id="btnImport" type="button" class="btn btn-danger" onclick="importView()">导入采样包</button></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="sampling:sampling:export">
			<li class="btns"><button id="btnExport" type="button" class="btn btn-danger" onclick="exportView()">导出采样包</button></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="sampling:sampling:dogInfoExport">
				<li class="btns"><button id="btnDogInfoExport" type="button" class="btn btn-danger" onclick="exportDogInfoView()">导出犬只信息</button></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><a id="allCheck" href="#" onclick="allCheck()"><input type="checkbox"/></a></th>
				<th>采样包编号</th>
				<th>犬只编号</th>
				<th>芯片号</th>
				<th>归属人</th>
				<th>绑定人</th>
				<th>绑定时间</th>
				<th>采样包状态</th>
				<th>送检时间</th>
				<th>备注</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sampling">
			<tr>
				<td>
					<c:choose>
						<c:when test="${sampling.bindType == 1 and sampling.flowState < 2}">
							<input type="checkbox"    class="checkedId" samplingId="${fns:escapeHtml(sampling.id)}"/>
						</c:when>
						<c:otherwise>
							<input type="checkbox"  onclick="return false;"  disabled  class="disabledCheckedId" sampling="${fns:escapeHtml(sampling.id)}"/>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<a href="${ctx}/sampling/sampling/viewForm?id=${sampling.id}">${sampling.samplingCode}</a>
				</td>
				<td>
					${sampling.dogCode}
				</td>
				<td>
					${sampling.chipCode}
				</td>
				<td>
					${sampling.memberName}
					<c:if test="${sampling.memberCode != null}">
						(${sampling.memberCode})
					</c:if>
				</td>
				<td>
					${sampling.bindUserName}
					<c:if test="${sampling.bindMemberCode != null}">
						(${sampling.bindMemberCode})
					</c:if>
				</td>
				<td>
					<fmt:formatDate value="${sampling.bindTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:choose>
						<c:when test="${sampling.flowState < 2}">
							${fns:getDictLabel(sampling.bindType, 'bind_type', '')}
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(sampling.flowState, 'sampling_flow_state', '')}
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<fmt:formatDate value="${sampling.sendTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td width="200px">
					${sampling.remarks}
				</td>
				<td>
					<shiro:hasPermission name="sampling:sampling:edit">
						<a href="${ctx}/sampling/sampling/editForm?id=${sampling.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="sampling:sampling:send">
						<c:if test="${sampling.bindType eq 1 and sampling.flowState < 2}">
						<a href="${ctx}/sampling/sampling/send?id=${sampling.id}"
						   onclick="return confirmx('确认要送检该采样包吗？', this.href)">送检</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="sampling:sampling:logout">
						<c:if test="${sampling.flowState ne 5}">
							<a href="${ctx}/sampling/sampling/logout?id=${sampling.id}"
							   onclick="return confirmx('确认要注销该采样包吗？', this.href)">注销</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="sampling:sampling:result">
						<c:if test="${sampling.flowState eq 2}">
							<a href="#" onclick="resultForm('${sampling.id}')">上传结果</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="sampling:sampling:del">
						<c:if test="${sampling.bindType eq 0}">
							<a href="${ctx}/sampling/sampling/delete?id=${sampling.id}"
							   onclick="return confirmx('确认要删除该采样包吗？', this.href)">删除</a>
						</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>