<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>退费记录管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.jbox-body .jbox-icon{
			top:50px!important;
		}
		.jbox-button-panel {
		    border-top: 1px solid #ccc;
		    background-color: #eee;
		    padding:0px!important;
		}
		.alert-danger, .alert-error{
			color: #bd4247;
		    background-color: #f2bdb1;
		    border-color: #f0a5a4;
		    text-align: justify;
		    text-justify: newspaper;
		    word-break: break-all;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"退款订单导入", buttons:{"关闭":true},bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
			
			$("#selectAll").click(function(){
				if($(this).is(':checked')){
					$("input[name='refundOrderCode']").not(":disabled").each(function(){this.checked=true;});
				}else{
					$("input[name='refundOrderCode']").not(":disabled").each(function(){this.checked=false;});
				}
			});
			
			$("#batchRefundOrderBtn").click(function(){
				var orderCodes = "";
				var orderCodeSize = $("input[name='refundOrderCode']:checkbox:checked").size();
				if(orderCodeSize == 0){
					$.jBox.error("请选择退款单后重试！","系统提示");
					return;
				}
				$("input[name='refundOrderCode']:checkbox:checked").each(function(index,obj){ 
					orderCodes += $(obj).val();
					if(orderCodeSize > index+1){
						orderCodes += ",";
					}
				});
				batchRefundOrder(orderCodes);
			});
		});
		
		function batchRefundOrder(orderCodes){
			if(orderCodes == null || orderCodes == ''){
				$.jBox.error("请选择退款单后重试！","系统提示");
				return;
			}
			$.jBox.confirm("确认要进行此操作吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					loadFun("batchRefundOrderBtn");
					$.ajax({
						url:'${ctx}/finance/paymentOrderRefund/audit',
						data:JSON.stringify(orderCodes.split(",")),
						contentType: 'application/json;charset=UTF-8',
						type:'post',
						cache:false,
						success:function(json){
							closeLoadFun("batchRefundOrderBtn");
							if(json.rc==0){
								alert("处理退款成功!");
								window.location.reload();
							}else{
								$.jBox.error(json.msg,"系统提示");
							}
						},
						error:function(){
							closeLoadFun("batchRefundOrderBtn");
							$.jBox.error("网络或服务异常，请检查是否联网！","系统提示");
						}
					});
					
				}
			},{buttonsFocus:2,buttons: {'取消':'cancel','确定':'ok'}});
		}
		
		function loadFun(btnId){
			layer.load();
			$("#"+btnId).prop("disabled",true);
		}
		
		function closeLoadFun(btnId){
			layer.closeAll('loading');
			$("#"+btnId).prop("disabled",false);
		}
		
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		function editOrderRefund(id){
			parent.layer.open({
				type: 2,
				title: ['修改退费记录', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['620px', '550px'],
				content: "${ctx}/finance/paymentOrderRefund/form?id="+id,
			});
			return false;
		}
		
		function editOrderRefundCallback(data){
			window.location.reload();
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/finance/paymentOrderRefund/">退费记录列表</a></li>
		<shiro:hasPermission name="finance:paymentOrderRefund:edit"><li><a href="${ctx}/finance/paymentOrderRefund/form">退费记录添加</a></li></shiro:hasPermission>
	</ul>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/finance/paymentOrderRefund/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');">
			<br/><br/><input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<a style="margin-left:5px;margin-top:7px;float:right;cursor:pointer;" href="${ctx}/finance/paymentOrderRefund/import/template">下载模板</a>
			<input id="btnImportSubmit" class="btn btn-primary" style="float:right;" type="submit" value="   导    入   "/>
		</form>
	</div>
	<form:form id="searchForm" modelAttribute="paymentOrderRefund" action="${ctx}/finance/paymentOrderRefund/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>订单编号：</label>
				<form:input path="orderCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员名称：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="150" class="input-medium"/>
			</li>
			<li><label>部分退费：</label>
				<form:select path="partRefundFlag" class="input-medium" style="width:177px;">
					<form:option value="" label="全部"/>
					<form:option value="true" label="是"/>
					<form:option value="false" label="否"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium" style="width:177px;">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<input id="btnSubmit" class="btn btn-primary" style="margin-left:10px;" type="submit" value="查询"/>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<div class="panel panel-default">
		<div class="panel-body">
			<form:form id="searchForm" modelAttribute="paymentOrderProject" action="${ctx}/finance/paymentOrderRefund/order" method="post" class="breadcrumb form-search">
				<ul class="ul-form">
					<shiro:hasPermission name="finance:paymentOrderRefund:edit">
						<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="退款订单导入"/></li>
					</shiro:hasPermission>
					<shiro:hasPermission name="finance:paymentOrderRefund:audit">
						<li class="btns"><input id="batchRefundOrderBtn" class="btn btn-danger" type="button" value="批量退费"/></li>
					</shiro:hasPermission>
					<li class="clearfix"></li>
				</ul>
			</form:form>
		</div>
	</div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><input id="selectAll" type="checkbox"/></th>
				<th>会员名称</th>
				<th>订单编号</th>
				<th>订单金额</th>
				<th>部分退费</th>
				<th>部分退费金额</th>
				<th>退款备注</th>
				<th>缴费项目</th>
				<th>处理状态</th>
				<th>处理时间</th>
				<th>创建时间</th>
				<shiro:hasPermission name="finance:paymentOrderRefund:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentOrderRefund">
			<tr>
				<td>
					<input type="checkbox" name="refundOrderCode" value="${paymentOrderRefund.id}" ${paymentOrderRefund.processState ne '0'?'disabled':''}/>
				</td>
				<td>
					${paymentOrderRefund.memberName} - ${paymentOrderRefund.memberCode}
				</td>
				<td>
					${paymentOrderRefund.orderCode}
				</td>
				<td>
					${paymentOrderRefund.totalPrice}
				</td>
				<td style="text-align:center;">
					<c:if test="${paymentOrderRefund.partRefundFlag}">
						<font color="red">是</font>
					</c:if>
					<c:if test="${!paymentOrderRefund.partRefundFlag}">
						<font color="green">否</font>
					</c:if>
				</td>
				<td>
					${paymentOrderRefund.partRefundPrice}
				</td>
				<td>
					<div title="${paymentOrderRefund.refundRemark}" style="max-width:290px;overflow: hidden;text-overflow:ellipsis;white-space: nowrap;">${paymentOrderRefund.refundRemark}</div>
				</td>
				<td>
					${paymentOrderRefund.chargingItemName}
				</td>
				<td style="text-align:center;">
					${fns:getDictLabel(paymentOrderRefund.processState, 'proccess_state', '')}
				</td>
				<td>
					<fmt:formatDate value="${paymentOrderRefund.processTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${paymentOrderRefund.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				
				<td>
					<shiro:hasPermission name="finance:paymentOrderRefund:audit">
						<c:if test="${paymentOrderRefund.processState eq '0'}">
							<a href="###" onclick="batchRefundOrder('${paymentOrderRefund.id}');">退费</a>
						</c:if>
						<c:if test="${paymentOrderRefund.processState ne '0'}">
							<font color="gray">退费</font>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="finance:paymentOrderRefund:audit">
						<c:set var="auditPermission" value="true" ></c:set>
					</shiro:hasPermission>
					<shiro:hasPermission name="finance:paymentOrderRefund:edit">
						<c:if test="${currentUser.id eq paymentOrderRefund.createBy.id || auditPermission}">
							<c:if test="${paymentOrderRefund.processState eq '0'}">
								<a href="###" onclick="editOrderRefund('${paymentOrderRefund.id}');">修改</a>
								<a href="${ctx}/finance/paymentOrderRefund/delete?id=${paymentOrderRefund.id}" onclick="return confirmx('确认要删除该退费记录吗？', this.href)">删除</a>
							</c:if>
							<c:if test="${paymentOrderRefund.processState ne '0'}">
								<font color="gray">修改</font>
								<font color="gray">删除</font>
							</c:if>
						</c:if>
					</shiro:hasPermission>
				</td>
				
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>