<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
		});

		function iFrameHeight(index) {
			var ifm= document.getElementById("iframepage"+index);
			var chargingItemId = $("#chargingItemId"+index).val();
			var chargingItems = $("input[name='chargingItemId"+chargingItemId+"']");
			var insertOrderMaxLength =0;
			for(var i=0;i<chargingItems.length;i++){
				insertOrderMaxLength+=parseInt(chargingItems[i].max);

			};
			var innerLength = $("#iframepage"+index).contents().find('tbody tr').length;
			if(parseInt(innerLength)>=parseInt(insertOrderMaxLength)){
				$("#insertOrder"+index).attr("onclick","");
				$("#insertOrder"+index).html("订单已经录入完毕");
			}
			var subWeb = document.frames ? document.frames["iframepage"+index].document : ifm.contentDocument;
			if(ifm != null && subWeb != null) {
				//document 总高度
				//ifm.height = subWeb.body.scrollHeight;
				//document 可见高度
				ifm.height = subWeb.body.offsetHeight;
			}
		}
		function insertOrder(url){
			parent.layer.open({
				type: 2,
				title: ['订单录入', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['750px', '600px'],
				content: url,
				end: function(){
					if(parent.isYes){
						closeLoading();
						window.location.reload();
					};
				}
			});
		}
		function cancledOrder(id) {
			var list = $('a[name="insertOrderItem"]');
			if(list.length >= 1){
				$('a[name="insertOrderItem"]').each(function() {
					if($(this).html() == "订单已经录入完毕"){
						alert("该订单已经录入完毕、不能作废");
					}else{
						window.location.href = "${ctx}/finance/paymentOrder/cancled?orderId="+id;
					}
				});
			}else{
				window.location.href = "${ctx}/finance/paymentOrder/cancled?orderId="+id;
			}
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/paymentOrder/">订单列表</a></li>
		<shiro:hasPermission name="finance:paymentOrderProject:view"><li><a href="${ctx}/finance/paymentOrderProject/">项目活动</a></li></shiro:hasPermission>
		<li class="active"><a href="${ctx}/finance/paymentOrder/form?id=${paymentOrder.id}">订单详情</a></li>
	</ul><br/>
	<div class="breadcrumb form-search">
		<ul class="ul-form">
			<div class="alert alert-warning" role="alert">
				<label>订单编号：${fns:escapeHtml(paymentOrder.orderCode)}</label>
				<label>订单状态：${fns:getDictLabel(paymentOrder.paymentState,'user_payment_state' ,'' )}</label>
				<shiro:hasPermission name="finance:paymentOrder:locked">
				<label><a class="btn" href="${ctx}/finance/paymentOrder/locked?id=${paymentOrder.id}&locked=${paymentOrder.locked}">
					<c:if test="${paymentOrder.locked=='0'}">
						锁定
					</c:if>
					<c:if test="${paymentOrder.locked=='1'}">
						解锁
					</c:if>
				</a></label>
				</shiro:hasPermission>
				<label>会员号：${fns:escapeHtml(paymentOrder.memberCode)}</label>
				<shiro:hasPermission name="finance:paymentOrder:cancled">
				<c:if test="${paymentOrder.delFlag =='0' && isShowCancel}">
					<label><a class="btn" href="#" onclick="cancledOrder('${paymentOrder.id}')">作废</a></label>
				</c:if>
				</shiro:hasPermission>
				<label><a class="btn" onclick="history.go(-1)">返 回</a></label>
			</div>
		</ul>
		<div class="form-actions">
			<c:forEach var="detail" items="${paymentOrder.orderDetailList}" varStatus="i">
				<div>
					<label style="width:100%">
						商品名称：${fns:escapeHtml(detail.chargingItemName)}   数量：<span>${fns:escapeHtml(detail.num)}</span>   单价：${fns:escapeHtml(detail.price)}   总价：${fns:escapeHtml(detail.totalPrice)}   时间：<fmt:formatDate value="${detail.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
						<input type="hidden" name="chargingItemId${detail.chargingItemId}" id="chargingItemId${i.index}" max="${fns:escapeHtml(detail.num)}" value="${detail.chargingItemId}">
						<br/>
						<c:if test="${paymentOrder.paymentState==2 && paymentOrder.delFlag == 0}">
							<shiro:hasPermission name="finance:paymentOrder:changeStatus">
								<c:if test="${detail.proccessState==0}">
									<c:if test="${detail.businessRefundState!='1'  and detail.businessRefundState!='3'}">
										<a style="color: #00a2d4;" href="${ctx}/finance/paymentOrder/updateProccessState?detailId=${detail.id}&id=${paymentOrder.id}">订单处理</a>
									</c:if>
									<c:if test="${detail.businessRefundState=='1'  || detail.businessRefundState=='3'}">
										<a>订单退款暂停处理</a>
									</c:if>
								</c:if>
								<c:if test="${detail.proccessState==1}">
									<a>订单已处理</a>
								</c:if>
							</shiro:hasPermission>
							<shiro:hasPermission name="finance:paymentOrder:orderItem">
								<c:if test="${detail.paymentChargingItem.type==1}">

									<c:if test="${not empty detail.businessIds}">
										<a  style="color: #00a2d4;" id="insertOrder${i.index}" name="insertOrderItem">订单已录入</a>
									</c:if>
									<c:if test="${empty detail.businessIds}">
										<a  style="color: #00a2d4;" id="insertOrders${i.index}" name="insertOrderItem" onclick="insertOrder('${detail.paymentChargingItem.jumpUrl}/?runningNumber=${paymentOrder.orderCode}&chargingItemId=${detail.chargingItemId}&memberCode=${detail.memberCode}&id=${detail.id}')">订单录入</a>
									</c:if>
									<%--									1	普通登录 194
                                        2	铜制登录 193
                                        3	银质登录 192
                                        4	金质登录 191
                                        5	超级登录 49
                                        6	世界冠军登录 50
                                        7	青年冠军登录 218--%>
										<c:choose>
											<c:when test="${detail.paymentChargingItem.id eq '194' || detail.paymentChargingItem.id eq 'a5142d9719824e6a987fa090e0570b2c'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=1&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:when test="${detail.paymentChargingItem.id eq '193'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=2&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:when test="${detail.paymentChargingItem.id eq '192'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=3&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:when test="${detail.paymentChargingItem.id eq '191'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=4&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:when test="${detail.paymentChargingItem.id eq '49' || detail.paymentChargingItem.id eq '3bf959b482aa459bbe5730fcb74ac24f' || detail.paymentChargingItem.id eq '24d78920df4e4c50bb8d03e1a4706bde' || detail.paymentChargingItem.id eq 'e81a20bb6968434689cb4a42700112e3'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=5&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:when test="${detail.paymentChargingItem.id eq '50'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=6&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:when test="${detail.paymentChargingItem.id eq '218' || detail.paymentChargingItem.id eq '2f73bbd1890844cc86ae692c68e6cdfa' || detail.paymentChargingItem.id eq '9285afb4c0a147e380024edcab89399b'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&loginType=7&chargingItemId=${detail.paymentChargingItem.id}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>

											<c:when test="${detail.paymentChargingItem.id eq 'bfd0cbf4a1844cd5824c36efbf4c64f2' || detail.paymentChargingItem.id eq 'e9c37c8005c141b39cdfdee1f45b802d'}">
												<iframe src="${detail.paymentChargingItem.showUrl}/?id=${detail.businessIds}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:when>
											<c:otherwise>
												<iframe src="${detail.paymentChargingItem.showUrl}/?runningNumber=${paymentOrder.orderCode}&chargingItemId=${detail.paymentChargingItem.id}&businessIds=${detail.businessIds}" width="100%"id="iframepage${i.index}" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" onLoad="iFrameHeight(${i.index})"></iframe>
											</c:otherwise>
                                        </c:choose>

								</c:if>
							</shiro:hasPermission>
						</c:if>
					</label>
				</div>
			</c:forEach>
		</div>
	</div>
</body>
</html>