<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员账户资金收支明细</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/finance/memberAccount/");
			$("#searchForm").submit();
			$("#btnSubmit").attr('disabled',"true");
	    	return false;
	    }

	</script>
</head>
<body>
	<div class="alert" role="alert" style="text-align: right;">余额总计：${countPrice}元</div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>付款人会员号</th>
				<th>充值金额</th>
				<th>订单金额</th>
				<th>账户余额</th>
				<th>部门</th>
				<th>收支类型</th>
				<th>支付方式</th>
				<c:if test="${payType!=null&&payType=='3'||payType=='23'||payType=='21'||payType=='8'}"><th>凭证编号</th></c:if>

				<th>缴费时间</th>
				<th>退款状态</th>
				<th>备注</th>
				<th>操作人</th>
                <th>操作</th>
			</tr>
		</thead>
		<tbody>

		<c:forEach items="${page.list}" var="memberAccount">
			<tr>
				<td>
					${fns:escapeHtml(memberAccount.runningNumber)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.memberName)}
				</td>
				<td>
					<c:if test="${memberAccount.cmember!=null}">${fns:escapeHtml(memberAccount.cmember)}</c:if>
					<c:if test="${memberAccount.cmember==null&&memberAccount.orgmember!=null}">${fns:escapeHtml(memberAccount.orgmember)}</c:if>
					<c:if test="${memberAccount.cmember==null&& memberAccount.orgmember==null }">${fns:escapeHtml(memberAccount.memberCode)}</c:if>
				</td>
				<td>
					<c:if test="${memberAccount.chargingItemName=='账号充值'}">
						${fns:escapeHtml(memberAccount.paymentAmount)}
					</c:if>
				</td>
				<td>
					<c:if test="${memberAccount.chargingItemName!='账号充值'}">
						${fns:escapeHtml(memberAccount.paymentAmount)}
					</c:if>
						<%--	${fns:escapeHtml(memberAccount.paymentAmount)}--%>
				</td>
					<td>
                            ${fns:escapeHtml(memberAccount.balanceMoney)}
                    </td>


				<td>
					${fns:escapeHtml(memberAccount.chargingItemOfficeName)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.chargingItemName)}
				</td>

				<td>
					${fns:getDictLabel(memberAccount.paymentWay, 'payment_way', '')}
				</td>
				<c:if test="${payType!=null&&payType=='3'||payType=='23'||payType=='21'||payType=='8'}">
					<td>
							${memberAccount.voucherCode}
					</td>
				</c:if>
				<td>
					<fmt:formatDate value="${memberAccount.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${memberAccount.businessRefundState==1}">退款审核中</c:if>
					<c:if test="${memberAccount.businessRefundState==2}">未通过</c:if>
					<c:if test="${memberAccount.businessRefundState==3}">通过</c:if>
				</td>
				<td>
					${fns:escapeHtml(memberAccount.paymentRemarks)}
				</td>
				<td>
					${fns:escapeHtml(memberAccount.updateBy.name)}
				</td>
                <td>
                    <a href="${ctx}/finance/paymentOrder/form?orderCode=${memberAccount.runningNumber}">详情</a>
                </td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>