<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只种类管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogtype/dogType/">犬只种类列表</a></li>
		<shiro:hasPermission name="dogtype:dogType:edit"><li><a href="${ctx}/dogtype/dogType/form">犬只种类添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogType" action="${ctx}/dogtype/dogType/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬种类代码：</label>
				<form:input path="dogBreedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬种英文名：</label>
				<form:input path="breedEnName" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>犬种中文名：</label>
				<form:input path="breedCnName" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>犬种分类：</label>
				<form:select path="breedClass" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_breed_class')}" itemLabel="label" itemValue="value"  htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>组：</label>
				<form:input path="typeGroup" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<!-- <li><label>FCI：</label>
				<form:select path="fciFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="否"/>
					<form:option value="1" label="是"/>
				</form:select>
			</li> -->
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬种类代码</th>
				<th>犬种类英文名称</th>
				<th>犬种类中文名称</th>
				<th>犬种分类</th>
				<th>组</th>
				<th>当前最大序号</th>
				<!-- <th>FCI</th> -->
				<th>修改时间</th>
				<th>查看</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogType">
			<tr>
				<td><a href="${ctx}/dogtype/dogType/form?id=${dogType.id}">
					${fns:escapeHtml(dogType.dogBreedCode) }
				</a></td>
				<td>
					${fns:escapeHtml(dogType.breedEnName) }
				</td>
				<td>
					${fns:escapeHtml(dogType.breedCnName) }
				</td>
				<td>
					${fns:getDictLabel(dogType.breedClass,'dog_breed_class','')}
				</td>
				<td>
					${fns:escapeHtml(dogType.typeGroup) }
				</td>
				<td>
					${fns:escapeHtml(dogType.nowMaxNumber) }
				</td>
				<!-- <td>
					<c:if test="${dogType.fciFlag=='0'}">否</c:if>
					<c:if test="${dogType.fciFlag=='1'}">是</c:if>
				</td> -->
				<td>
					<fmt:formatDate value="${dogType.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<a href="${ctx}/dogtype/dogType/view?id=${fns:escapeHtml(dogType.id) }">查看</a>
				</td>
				<td>
				<shiro:hasPermission name="dogtype:dogType:editAlias">
    				<a href="${ctx}/dogtype/dogType/editAlias?id=${fns:escapeHtml(dogType.id) }">编辑别名</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogtype:dogType:edit">
    				<a href="${ctx}/dogtype/dogType/edit?id=${fns:escapeHtml(dogType.id) }">编辑</a>
					<a href="${ctx}/dogtype/dogType/delete?id=${fns:escapeHtml(dogType.id) }" onclick="return confirmx('确认要删除该犬只种类吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>