<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬只姓名</th>
				<th>鉴定证书号</th>
				<th>宠爱证书号</th>
				<th>犬种</th>
				<th>犬主</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>鉴定类型</th>
				<th>犬展鉴定编号</th>
				<th>鉴定地点</th>
				<th>订单状态</th>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:audit"><th>审核状态</th></shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:resolve"><th>处理</th></shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:delete"><th>删除</th></shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:print"><th>打印</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogAppraisal">
			<tr>
				<td>
					${fns:escapeHtml(dogAppraisal.dogName)}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.chongaiCertificateCode)}
				</td>
				<td title="${fns:escapeHtml(dogAppraisal.breedCnName)}">
					${fns:escapeHtml(dogAppraisal.dogBreed)}
				</td>
				<td title="${fns:escapeHtml(dogAppraisal.paymentMemberCode)}">
					${fns:escapeHtml(dogAppraisal.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogAppraisal.birthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogAppraisal.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:getDictLabel(dogAppraisal.identifyType, 'dog_appraisal_type', '')}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.showAppraisalCode)}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.identifySite)}
				</td>
				<td style="color:${dogAppraisal.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogAppraisal.paymentState, 'user_payment_state', '')}
				</td>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:audit">
				<td style="color:#000">
					<c:if test="${dogAppraisal.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogAppraisal.reviewState=='2'}">
							<a style="color:#F00" href="${ctx}/dogappraisal/dogAppraisal/form?id=${dogAppraisal.id}">
							${fns:getDictLabel(dogAppraisal.reviewState, 'dog_appraisal_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogAppraisal.reviewState=='0'}">
							<a style="color:#000" title="${fns:escapeHtml(dogAppraisal.reviewRemarks)}">
							${fns:getDictLabel(dogAppraisal.reviewState, 'dog_appraisal_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogAppraisal.reviewState, 'dog_appraisal_review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:resolve">
				<td style="color:#000">
					<c:if test="${dogAppraisal.reviewState=='1'}">
    					<c:choose>
							<c:when test="${dogAppraisal.processState=='0'}">
								<a href="${ctx}/dogappraisal/dogAppraisal/resolve?id=${dogAppraisal.id}" style="color:#F00" onclick="return confirmx('确认要处理该犬只鉴定吗？', this.href)">
								${fns:getDictLabel(dogAppraisal.processState, 'proccess_state', '')}
								</a>
							</c:when>
							<c:otherwise>
								${fns:getDictLabel(dogAppraisal.processState, 'proccess_state', '')}
							</c:otherwise>
    					</c:choose>
    				</c:if>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:delete">
				<td>
					<a href="${ctx}/dogappraisal/dogAppraisal/delete?id=${dogAppraisal.id}" onclick="return confirmx('确认要删除该犬只鉴定吗？', this.href)">删除</a>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:print">
				<td>
					<c:if test="${dogAppraisal.reviewState=='1'&&dogAppraisal.processState=='1'}">
						<c:if test="${dogAppraisal.identifyType=='1'}">
						<a href="${ctx}/dogappraisal/dogAppraisal/printDna?id=${dogAppraisal.id}">DNA打印</a>.
						</c:if>
						<a href="${ctx}/dogappraisal/dogAppraisal/print?id=${dogAppraisal.id}">鉴定打印</a>
					</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>