<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>血统证书编号</th>
		<th>国外血统证书号</th>
		<th>犬主</th>
		<th>出生纸编号</th>
		<th>申请日期</th>
		<th>订单状态</th>
		<th>审核状态</th>
		<th>撤销状态</th>
		<th>DNA信息</th>
		<th>操作</th>
		<th>打印</th>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${list}" var="dogDnaArchive">
		<tr>
			<td>
					${fns:escapeHtml(dogDnaArchive.pedigreeCertifiedCode)}
			</td>
			<td>
					${fns:escapeHtml(dogDnaArchive.overseasPedigreeCertified)}
			</td>
			<td title="${fns:escapeHtml(dogDnaArchive.paymentMemberCode)}">
					${fns:escapeHtml(dogDnaArchive.memberName)}
			</td>
			<td>
					${fns:escapeHtml(dogDnaArchive.birthCode)}
			</td>
			<td>
				<fmt:formatDate value="${dogDnaArchive.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			<td style="color:${dogDnaArchive.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogDnaArchive.paymentState, 'user_payment_state', '')}
			</td>
			<td title="${fns:escapeHtml(dogDnaArchive.reviewRemarks)}" style="color:#000">
				<c:if test="${dogDnaArchive.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogDnaArchive.reviewState=='0' and !dogDnaArchive.businessRefundState}">
							<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogDnaArchive.id)}')">
									${fns:getDictLabel(dogDnaArchive.reviewState, 'review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogDnaArchive.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
				</c:if>
			</td>
			<td>
				<c:if test="${dogDnaArchive.isCanceled=='1'}">
					已撤销
				</c:if>
			</td>
			<td>
			<c:if test="${!dogDnaArchive.businessRefundState}">
				<c:choose>
					<c:when test="${not empty dogDnaArchive.dnaCode}">
						<a onclick="resolveForm('${dogDnaArchive.id}')">${fns:escapeHtml(dogDnaArchive.dnaCode)}</a>
					</c:when>
					<c:when test="${empty dogDnaArchive.dnaCode&&dogDnaArchive.reviewState=='1'}">
						<a style="color:#F00" onclick="resolveForm('${dogDnaArchive.id}')">录入</a>
					</c:when>
				</c:choose>
			</c:if>
			</td>
			<td>
				<a href="${ctx}/dnaarchive/dogDnaArchive/form?id=${dogDnaArchive.id}">查看</a>
				<c:if test="${!dogDnaArchive.businessRefundState}">
					<shiro:hasPermission name="dnaarchive:dogDnaArchive:edit">
						<a href="${ctx}/dnaarchive/dogDnaArchive/editForm?id=${dogDnaArchive.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="dnaarchive:dogDnaArchive:delete">
						<a href="${ctx}/dnaarchive/dogDnaArchive/delete?id=${dogDnaArchive.id}" onclick="return confirmx('确认要删除该犬只DNA存档吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</c:if>
			</td>
			<td>
				<shiro:hasPermission name="dnaarchive:dogDnaArchive:print">
					<c:if test="${not empty dogDnaArchive.dnaCode && dogDnaArchive.printState=='0'}">
						<a href="${ctx}/dnaarchive/dogDnaArchive/print?id=${dogDnaArchive.id}" >打印</a>
					</c:if>
				</shiro:hasPermission>
				<shiro:hasPermission name="dnaarchive:dogDnaArchive:resetPrint">
					<c:if test="${not empty dogDnaArchive.dnaCode && dogDnaArchive.printState=='1'}">
						<a href="${ctx}/dnaarchive/dogDnaArchive/resetPrint?id=${dogDnaArchive.id}" >重置打印</a>
					</c:if>
				</shiro:hasPermission>
			</td>
		</tr>
	</c:forEach>
	</tbody>
</table>
</body>
</html>