<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>报名信息编辑</title>
<meta name="decorator" content="default" />
<script type="text/javascript">
	$(document).ready(function() {
		initAddress();

	   	 // 清空
		$("#btnCancel").on('click' , function(){
			$("#memberName").val("");
			$("#shopName").val("");

			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			initAddress();
		});
		
		// 提交
		$("#btnSubmit").on('click' , function(){
			var memberName = $("#memberName").val();
			var shopName = $("#shopName").val();
			var province = $("#province").val();
			var city = $("#city").val();
			var area = $("#area").val();
			var id = $("#id").val();
			
			if(memberName == ''){ alert("姓名不能为空!"); return};
			if(shopName == ''){ alert("店名不能为空!"); return };
			if(province == ''){ alert("所在地省不能为空!"); return };
			if(city == ''){ alert("所在地市不能为空!"); return };
			if(area == ''){ alert("所在地区不能为空!"); return };

			memberName = encodeURIComponent(memberName);
			$.ajax({
				url:'${ctx}/appreciation/appreciationApply/editAddress',
				data : {
					memberName : memberName,
					shopName : shopName,
					province : province,
					city : city,
					area : area,
					id : id
				},
				async:true,
				loadFlag:true,
				type:'post',
				cache:false,
				success:function(json){
					if(json == "OK"){
						var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
						parent.layer.close(index);
					}
				}
			});
			
			
		});
		
		// ===== 省市区联动  =====
		$("#province").change(function(){
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			var code = $(this).find("option:selected").attr("code");
			$.ajax({
				url:'${ctxCity}',
				data: {province_code:code},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option  value='' code=''>请选择</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
						}
						$("#city").append(html);
					}else{
						layer.msg(json.msg);
					}
				}
			});
		})
		$("#city").change(function(){
			$("#area").empty().val("").select2();
			var code = $(this).find("option:selected").attr("code");
			$.ajax({
				url:'${ctxArea}',
				data: {city_code:code},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option value='' code=''>请选择</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
						}
						$("#area").append(html);
					}else{
						layer.msg(json.msg);
					}
				}
			});
		})
		
	});

	

    function initAddress(){
		var oldProvince = '${appreciationApply.province}';
		var oldCity = '${appreciationApply.city}';
		var oldArea = '${appreciationApply.area}';

		var oldProvinceCode = "";
		var oldCityCode = "";
		
		$("#province").empty().val("").select2();
		$("#city").empty().val("").select2();
		$("#area").empty().val("").select2();
		
		$.ajax({
			url:'${ctxProvince}',
			data: {},
			async:true,
			loadFlag:true,
			type:'get',
			cache:false,
			async: false,
			success:function(json){
				if(json.rc==0){
					var html = "<option  value='' code=''>请选择</option>";
					var lists = json.items;
					for(var i = 0;i<lists.length;i++){
						if(lists[i].province == oldProvince){
							oldProvinceCode = lists[i].provinceId;
						}
						html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
					}
					$("#province").append(html);
					if(oldProvince != ''){
						$("#province").val(oldProvince);
					}
					$("#province").trigger("change");
				}else{
					layer.msg(json.msg);
				}
			}
		});

		$.ajax({
			url:'${ctxCity}',
			data: {province_code:oldProvinceCode},
			async:true,
			loadFlag:true,
			type:'get',
			cache:false,
			async: false,
			success:function(json){
				if(json.rc==0){
					var html = "<option  value='' code=''>请选择</option>";
					var lists = json.items;
					for(var i = 0;i<lists.length;i++){
						if(lists[i].city == oldCity){
							oldCityCode = lists[i].cityId;
						}
						html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
					}
					$("#city").append(html);
					if(oldCity != ''){
						$("#city").val(oldCity);
					}
					$("#city").trigger("change");
			        
				}else{
					layer.msg(json.msg);
				}
			}
		});

		$.ajax({
			url:'${ctxArea}',
			data: {city_code:oldCityCode},
			async:true,
			loadFlag:true,
			type:'get',
			cache:false,
			success:function(json){
				if(json.rc==0){
					var html = "<option  value='' code=''>请选择</option>";
					var lists = json.items;
					for(var i = 0;i<lists.length;i++){
						html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
					}
					$("#area").append(html);
					if(oldArea != ''){
						$("#area").val(oldArea);
					}
					 $("#area").trigger("change");
				}else{
					layer.msg(json.msg);
				}
			}
		});

    }
</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="appreciationApply"
		action="${ctx}/appreciation/appreciationApply/save" method="post"
		class="form-horizontal">

		<form:hidden path="id" />

		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="memberName" htmlEscape="false" maxlength="50"
					class="input-xlarge required" />
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">店名：</label>
			<div class="controls">
				<form:input path="shopName" htmlEscape="false" maxlength="50"
					class="input-xlarge required" />
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">所在地：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
			</div>
		</div>
		
		 <div class="form-actions">
		 	<!--  <input id="btnCancel" class="btn btn-primary" type="button" value="清 空" /> -->
       		 <input id="btnSubmit" class="btn btn-primary" type="button" value="提 交" />
    	</div>
	</form:form>
</body>
</html>