<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户管理</title>
	<meta name="decorator" content="default"/>
	<%@include file="/WEB-INF/views/include/treeview.jsp" %>
	<script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script src="${ctxStatic}/pinyin/pinyin-pro.js" type="text/javascript"></script>
	<script type="text/javascript">
		var { pinyin } = pinyinPro;
		$(document).ready(function() {
			$("#name").change(function(){
				var nameVal = $(this).val();
				if(nameVal != null && nameVal != ''){
					top.$.jBox.confirm("是否将姓名拼音作为登录名？","系统提示",function(v,h,f){
						if(v=="ok"){
							$("#loginName").val(pinyin(nameVal, { toneType: 'none' }).replace(/\s/g, ''));
						}
					},{buttonsFocus:1});
					top.$('.jbox-body .jbox-icon').css('top','55px');
				}
			});
			
			$("#no").focus();
			$("#inputForm").validate({
				rules: {
					loginName: {
						required: true,
						remote:{    
							url : "${ctx}/sys/user/checkLoginName",    
							type : "get",    
							dateType:"json",    
							data:{oldLoginName:'${user.loginName}',userType : function(){
								return $("#userType option:selected").val();
							}}    
						}    
					},
					email: {remote: "${ctx}/sys/user/checkEmail?oldEmail=" + encodeURIComponent('${user.email}')}
				},
				messages: {
					loginName: {remote: "用户登录名已存在"},
					email: {remote: "用户邮箱已存在"},
					confirmNewPassword: {equalTo: "输入与上面相同的密码"}
				},
				/* submitHandler: function(form){
					var ids = [], nodes = tree.getCheckedNodes(true),pValue = [];
					for(var i=0; i<nodes.length; i++) {
						ids.push(nodes[i].id);
						pValue.push(nodes[i].value);
					}
					$("#permissions").val(ids);
					$("#permissionValues").val(pValue);
					loading('正在提交，请稍等...');
					form.submit();
				}, */
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			
			var setting = {check:{enable:true,nocheckInherit:true},view:{selectedMulti:false},
					data:{simpleData:{enable:true}},callback:{beforeClick:function(id, node){
						tree.checkNode(node, !node.checked, true, true);
						return false;
					}}};
			
			// 用户-菜单
			var zNodes=[
					<c:forEach items="${menuList}" var="menu">{id:"${menu.id}",value:"${menu.permission}", pId:"${not empty menu.parent.id?menu.parent.id:0}", name:"${not empty menu.parent.id?menu.name:'权限列表'}"},
		            </c:forEach>];
			// 初始化树结构
			var tree = $.fn.zTree.init($("#menuTree"), setting, zNodes);
			// 不选择父节点
			tree.setting.check.chkboxType = { "Y" : "ps", "N" : "s" };
			// 默认选择节点
			var ids = "${user.permissions}".split(",");
			for(var i=0; i<ids.length; i++) {
				var node = tree.getNodeByParam("id", ids[i]);
				try{tree.checkNode(node, true, false);}catch(e){}
			}
			
			$("#userType").change(function(){
				//当用户类型发生变化时，模拟用户输入触发loginName的重复验证
				var loginName = $("#loginName").val();
				$("#loginName").val(loginName+"  ");
				$("#loginName").blur();
				$("#loginName").focus();
				$("#loginName").val(loginName);
				$("#loginName").blur();
				$("#inputForm").validate().element($("#loginName"));
			});
			
			$("#btnSubmit").click(function(){
				
				var ids = [], nodes = tree.getCheckedNodes(true),pValue = [];
				for(var i=0; i<nodes.length; i++) {
					ids.push(nodes[i].id);
					pValue.push(nodes[i].value);
				}
				$("#permissions").val(ids);
				$("#permissionValues").val(pValue);
				
				$("#inputForm").ajaxSubmit({
			        dataType: 'json',
			        beforeSubmit: function(){
						if (!$("#inputForm").valid() || $(".error:visible").length > 0){
							return false;
						}
						else{
				            return true; 
						}
			        },
			        success: function(data){
			            top.layer.msg(data.msg);
					    if(data.rc == 0){
					    	var selectedNodes = window.parent.getSelectedNodes();
					    	var queryOfficeId = "";
							var queryOfficeName = "";
							if(selectedNodes != null && selectedNodes != undefined && selectedNodes.length > 0){
								queryOfficeId = selectedNodes[0].id;
								queryOfficeName = selectedNodes[0].name;
							}
							window.location = "${ctx}/sys/user/list?office.id="+queryOfficeId+"&office.name="+queryOfficeName;
					    }
			        },  
			        error: function(err) {            
			            alert("操作失败!");
			        }
				});
			});
			
			
			$("#btnPermissions").click(function(){
				top.layer.open({
	                type: 2,
	                title: ['权限复制用户查询', 'font-size:18px;text-align: center;'],
	                shadeClose: false,
	                shade: [0.8, '#393D49'],
	                maxmin: false, //开启最大化最小化按钮
	                area: ['750px', '500px'],
	                content: "${ctx}/sys/user/search"
	            });
			});
		});

		//查询用户完成的回调方法
        this.searchUserCallback = function (userData) {
            $("#permissions").val(userData.permissions);
			$("#permissionValues").val(userData.permissionValues);
         	// 默认选择节点
			var ids = userData.permissions.split(",");
         	var currTree = $.fn.zTree.getZTreeObj("menuTree");
         	currTree.checkAllNodes(false);
			for(var i=0; i<ids.length; i++) {
				var node = currTree.getNodeByParam("id", ids[i]);
				try{currTree.checkNode(node, true, false);}catch(e){}
			}
        }
		
		//查询用户完成的回调方法
        this.searchUserCallback = function (userData) {
            $("#permissions").val(userData.permissions);
			$("#permissionValues").val(userData.permissionValues);
         	// 默认选择节点
			var ids = userData.permissions.split(",");
         	var currTree = $.fn.zTree.getZTreeObj("menuTree");
         	currTree.checkAllNodes(false);
			for(var i=0; i<ids.length; i++) {
				var node = currTree.getNodeByParam("id", ids[i]);
				try{currTree.checkNode(node, true, false);}catch(e){}
			}
        }

		
	</script>
</head>
<body >
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/user/form?id=${user.id}">用户<shiro:hasPermission name="sys:user:edit">${not empty user.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="sys:user:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="user" action="${ctx}/sys/user/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<!-- 
		<div class="control-group">
			<label class="control-label">头像:</label>
			<div class="controls">
				<form:hidden id="nameImage" path="photo" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="nameImage" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>
			</div>
		</div>
		 -->
		<c:if test="${empty user.userType=='2'}">
		<div class="control-group">
			<label class="control-label">归属公司:</label>
			<div class="controls">
                <sys:treeselect id="company" name="company.id" value="${user.company.id}" labelName="company.name" labelValue="${user.company.name}"
					title="公司" url="/sys/office/treeData?type=1" cssClass=""/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">归属部门:</label>
			<div class="controls">
                <sys:treeselect id="office" name="office.id" value="${user.office.id}" labelName="office.name" labelValue="${user.office.name}"
					title="部门" url="/sys/office/treeData?type=2" cssClass="" notAllowSelectParent="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">工号:</label>
			<div class="controls">
				<form:input path="no" htmlEscape="false" maxlength="50" class=""/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		</c:if>
		<c:if test="${empty user.userType!='2'}">
		<div class="control-group">
			<label class="control-label">归属公司:</label>
			<div class="controls">
                <sys:treeselect id="company" name="company.id" value="${user.company.id}" labelName="company.name" labelValue="${user.company.name}"
					title="公司" url="/sys/office/treeData?type=1" cssClass="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">归属部门:</label>
			<div class="controls">
                <sys:treeselect id="office" name="office.id" value="${user.office.id}" labelName="office.name" labelValue="${user.office.name}"
					title="部门" url="/sys/office/treeData?type=2" cssClass="required" notAllowSelectParent="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">工号:</label>
			<div class="controls">
				<form:input path="no" htmlEscape="false" maxlength="50" class="required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">姓名:</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="50" class="required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<c:if test="${empty user.id}">
		<div class="control-group">
			<label class="control-label">用户类型:</label>
			<div class="controls">
				<form:select path="userType" class="input-xlarge required">
					<%--<form:option value="1" label="系统用户"/>--%>
					<form:options items="${fns:getDictList('sys_user_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">登录名:</label>
			<div class="controls">
				<input id="oldLoginName" name="oldLoginName" type="hidden" value="${user.loginName}">
				<form:input path="loginName" htmlEscape="false" maxlength="50" class="required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">密码:</label>
			<div class="controls">
				<input id="newPassword" name="newPassword" type="password" value="" maxlength="50" minlength="3" class="${empty user.id?'required':''}"/>
				<c:if test="${empty user.id}"><span class="help-inline"><font color="red">*</font> </span></c:if>
				<c:if test="${not empty user.id}"><span class="help-inline">若不修改密码，请留空。</span></c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">确认密码:</label>
			<div class="controls">
				<input id="confirmNewPassword" name="confirmNewPassword" type="password" value="" maxlength="50" minlength="3" equalTo="#newPassword"/>
				<c:if test="${empty user.id}"><span class="help-inline"><font color="red">*</font> </span></c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱:</label>
			<div class="controls">
				<input id="oldEmail" name="oldEmail" type="hidden" value="${user.email}">
				<form:input path="email" htmlEscape="false" maxlength="100" class="email"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话:</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="100"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机:</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">是否允许登录:</label>
			<div class="controls">
				<form:select path="loginFlag">
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> “是”代表此账号允许登录，“否”则表示此账号不允许登录</span>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">邮箱激活状态:</label>
            <div class="controls">
                <form:select path="mailCheck">
                    <form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
		<c:if test="${user.userType eq '1' }">
		<div class="control-group" >
			<label class="control-label">用户授权:</label>
			<div class="controls">
				<c:if test="${operater.id eq '1'}">
				<div class="ztree" style="margin-top:3px;font-size:14px;">
					<input id="btnPermissions" class="btn btn-warning" type="button" value="权限复制"/>
				</div>
				</c:if>
				<div id="menuTree" class="ztree" style="margin-top:3px;float:left;"></div>
				<form:hidden path="permissions"/>
				<form:hidden path="permissionValues"/>
			</div>
			<div class="controls">
				<input type="checkbox" name="isShowSensitiveData" 
				${user.isShowSensitiveData!='0'?'checked="checked"':''} />敏感数据显示
			</div>
		</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">备注:</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="3" maxlength="200" class="input-xlarge"/>
			</div>
		</div>
		<c:if test="${not empty user.id}">
			<div class="control-group">
				<label class="control-label">创建时间:</label>
				<div class="controls">
					<label class="lbl"><fmt:formatDate value="${user.createDate}" type="both" dateStyle="full"/></label>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">最后登陆:</label>
				<div class="controls">
					<label class="lbl">IP: ${user.loginIp}&nbsp;&nbsp;&nbsp;&nbsp;时间：<fmt:formatDate value="${user.loginDate}" type="both" dateStyle="full"/></label>
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">打印左偏移量:</label>
			<div class="controls">
				<form:input path="printLeft" htmlEscape="false" maxlength="100"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">打印上偏移量:</label>
			<div class="controls">
				<form:input path="printTop" htmlEscape="false" maxlength="100"/>
			</div>
		</div>
		<c:if test="${fns:getUser().id=='1'}">
			<div class="control-group">
				<label class="control-label">后台用户管理部门:</label>
				<div class="controls">
					<form:input path="userListOffice" htmlEscape="false" maxlength="200"/>
				</div>
			</div>
		</c:if>
		<div class="form-actions">
			<shiro:hasPermission name="sys:user:edit"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>