package com.cku.schools.mrschool.service;

import static com.cku.restful.v1.groomer.service.RestGroomerRegisterService.PAYMENTCHARGINGITEM_SHORTNAME_NURSE;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerShowService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 *user chaixueteng
 *2017年6月22日
 */
@Service
@Transactional(readOnly = true)
public class SchoolsPaymentService {
	 public static final String MEMER_GROOMER_RESERVE = "sys_member@GR";//美容预备会员
	 public static final String MEMBER_GROOMER_FORMAL = "sys_member@GF";//美容正式会员
	 public static final String GROOMER_DIPLOMAL_FEE="groomer_diploma@F";//美容培训结业证书费
	 public static final String MEMER_GROOMER_SCHOOL="sys_member@GS";//合作学校合作费用
	 public static final String GROOMER_QUALIFICATION_CERTIFICATE_F="groomer_qualification_certificate@F";//国际宠物美容师资格证书（优惠）
	 public static final String GROOMER_QUALIFICATION_CERTIFICATE_C="groomer_qualification_certificate@C";//美容师C级资格证书费
	 public static final String GROOMER_QUALIFICATION_CERTIFICATE_PDG="groomer_qualification_certificate@pdg";//派多格资格证书收费项
	 @Autowired
	 private MemberService memberService;
	 @Autowired
	 private PaymentChargingItemDao paymentChargingItemDao;
	 @Autowired
	 private RestOrderService restOrderService;
	 @Autowired
	 private PaymentOrderDetailDao paymentOrderDetailDao;
	 @Autowired
	 private PaymentOrderService paymentOrderService;
	 @Autowired
	 private PaymentOrderDao paymentOrderDao;
	 @Autowired
	 private GroomerRegisterService groomerRegisterService;
	 @Autowired
	 private GroomerShowService groomerShowService;
	 @Autowired
	 private GroomerDiplomaService groomerDiplomaService;
	 
	/**
	 * 生成美容会员缴费订单及详情
	 * @Author chaixueteng
	 * @2017年6月22日上午10:44:56
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> MemberToOrder(String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		//设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(member);
		//构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder,member,"member",null);
		//计算订单总额
		Double orderTotal = 0d;
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
		}
		//保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		//回写订单详情的OrderCode字段
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		//保存订单详情
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		return paymentOrderDetailList;
	}

	private List<PaymentOrderDetail> buildGroomerRegisterPaymentOrderDetailList(PaymentOrder paymentOrder, Member member,String businessId){
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();

		GroomerRegister groomerRegister = groomerRegisterService.get(businessId);
		GroomerShow groomerShow = groomerShowService.getShowCode(groomerRegister.getShowCode());
		if("1".equals(groomerShow.getShowCategory())) {
			if("exam".equals(groomerShow.getShowType()) && "MASTER".equals(groomerRegister.getShowLevel())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@10", "500", false, businessId);
				paymentOrderDetailList.add(detail);
			}
			if("exam".equals(groomerShow.getShowType()) && !"MASTER".equals(groomerRegister.getShowLevel())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@10", groomerRegister.getFee(), true, businessId);
				paymentOrderDetailList.add(detail);
			}
			if("team".equals(groomerShow.getShowType()) && !"E".equals(groomerRegister.getShowLevel())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@E", "1200", false, businessId);
				paymentOrderDetailList.add(detail);
			}
			
			if("team".equals(groomerShow.getShowType()) && !"F".equals(groomerRegister.getShowLevel())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@F", "900", false, businessId);
				paymentOrderDetailList.add(detail);
			}
			
			if("match".equals(groomerShow.getShowType())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@12", groomerRegister.getFee(), true, businessId);
				paymentOrderDetailList.add(detail);
			}
			
			if("cathedra".equals(groomerShow.getShowType()) || "cathedra".equals(groomerShow.getShowType())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@11", groomerRegister.getFee(), true, businessId);
				paymentOrderDetailList.add(detail);
			}
			
		} else if("2".equals(groomerShow.getShowCategory())) {
			PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@Inter", groomerRegister.getFee(), true, businessId);
			paymentOrderDetailList.add(detail);
		} else if("3".equals(groomerShow.getShowCategory())) {
			PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@Pet", groomerRegister.getFee(), true, businessId);
			paymentOrderDetailList.add(detail);
		}else if("4".equals(groomerShow.getShowCategory())) {
			PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@nurse_"+groomerShow.getShowType(), groomerRegister.getFee(), true, businessId);
			paymentOrderDetailList.add(detail);
		} else if ("6".equals(groomerShow.getShowCategory())) {//
			PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@pdg", groomerRegister.getFee(), true, businessId);
			paymentOrderDetailList.add(detail);
		} else if ("8".equals(groomerShow.getShowCategory())) {//
			if ("exam".equals(groomerShow.getShowType()) && !"MASTER".equals(groomerRegister.getShowLevel())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@nurse_"+groomerShow.getShowType(), "300.00", true, businessId);
				paymentOrderDetailList.add(detail);
			}
			if ("exam".equals(groomerShow.getShowType()) && "MASTER".equals(groomerRegister.getShowLevel())) {
				PaymentOrderDetail detail = buidGroomerRegisterDetail(paymentOrder, "groomer_register@nurse_"+groomerShow.getShowType(), "500.00", true, businessId);
				paymentOrderDetailList.add(detail);
			}

		}
		
		return paymentOrderDetailList;
	}
	
	private PaymentOrderDetail buidGroomerRegisterDetail(PaymentOrder paymentOrder,String shorName , String fee , Boolean falg , String businessId) {
		PaymentChargingItem reserveItem = paymentChargingItemDao.getByShortName(shorName);
 		Double reserveFee = 0.0;
		if(falg) {
			reserveFee = Double.parseDouble(fee);
		}else {
			 reserveFee = Double.parseDouble(reserveItem.getPrice());
		}
		
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setOrderCode(paymentOrder.getOrderCode());
		detail.setAddTime(paymentOrder.getAddTime());
		detail.setProccessState("0");
		detail.setTotalPrice(reserveFee.toString());
		detail.setNum("1");
		detail.setPrice(reserveFee.toString());
		detail.setBusinessIds(businessId);
		detail.setBusinessTable("groomer_register");
		detail.setChargingItemId(reserveItem.getId());
		detail.setMemberCode(paymentOrder.getMemberCode());
		detail.setMemberName(paymentOrder.getMemberName());
		detail.setChargingItemName(reserveItem.getName());
		
		return detail;
	}

	/**
	 * 构造订单详情
	 * @Author chaixueteng
	 * @2017年6月22日上午10:50:44
	 */
	private List<PaymentOrderDetail> buildPaymentOrderDetailList(
			PaymentOrder paymentOrder, Member member, String type ,String businessId) {
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		if("member".equals(type)){// 会员续费订单
			String groomerType = member.getGroomerType();
			if("reserve".equals(groomerType)||StringUtils.isBlank(groomerType)){
				PaymentChargingItem reserveItem = paymentChargingItemDao.getByShortName(MEMER_GROOMER_RESERVE);
				Double reserveFee = Double.parseDouble(reserveItem.getPrice());//美容师预备会员费
				PaymentOrderDetail detail = new PaymentOrderDetail();
				detail.setOrderCode(paymentOrder.getOrderCode());
				detail.setAddTime(paymentOrder.getAddTime());
				detail.setProccessState("0");
				detail.setTotalPrice(reserveFee.toString());
				detail.setNum("1");
				detail.setPrice(reserveFee.toString());
				detail.setBusinessIds(member.getId());
				detail.setBusinessTable("sys_member");
				detail.setChargingItemId(reserveItem.getId());
				detail.setMemberCode(paymentOrder.getMemberCode());
				detail.setMemberName(paymentOrder.getMemberName());
				detail.setChargingItemName(reserveItem.getName());
				paymentOrderDetailList.add(detail);
			}else if("formal".equals(groomerType)){
				PaymentChargingItem formalItem = paymentChargingItemDao.getByShortName(MEMBER_GROOMER_FORMAL);
				Double formalFee = Double.parseDouble(formalItem.getPrice());//美容师正式会员费
				PaymentOrderDetail detail = new PaymentOrderDetail();
				detail.setOrderCode(paymentOrder.getOrderCode());
				detail.setAddTime(paymentOrder.getAddTime());
				detail.setProccessState("0");
				detail.setTotalPrice(formalFee.toString());
				detail.setNum("1");
				detail.setPrice(formalFee.toString());
				detail.setBusinessIds(member.getId());
				detail.setBusinessTable("sys_member");
				detail.setChargingItemId(formalItem.getId());
				detail.setMemberCode(paymentOrder.getMemberCode());
				detail.setMemberName(paymentOrder.getMemberName());
				detail.setChargingItemName(formalItem.getName());
				paymentOrderDetailList.add(detail);
			}
		}else if ("diploma".equals(type)){
			PaymentChargingItem diplomaItem = paymentChargingItemDao.getByShortName(GROOMER_DIPLOMAL_FEE);
			Double diplomaFee = Double.parseDouble(diplomaItem.getPrice());//美容师结业证书费
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setOrderCode(paymentOrder.getOrderCode());
			detail.setAddTime(paymentOrder.getAddTime());
			detail.setProccessState("0");
			detail.setTotalPrice(diplomaFee.toString());
			detail.setNum("1");
			detail.setPrice(diplomaFee.toString());
			detail.setBusinessIds(businessId);
			detail.setBusinessTable("groomer_diploma");
			detail.setChargingItemId(diplomaItem.getId());
			detail.setMemberCode(paymentOrder.getMemberCode());
			detail.setMemberName(paymentOrder.getMemberName());
			detail.setChargingItemName(diplomaItem.getName());
			paymentOrderDetailList.add(detail);
		}
		return paymentOrderDetailList;
	}


	/**
	 * 构造订单基本信息
	 * @Author chaixueteng
	 * @2017年6月22日上午10:46:46
	 */
	private PaymentOrder buildPaymentOrder(Member member) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String loginType = ti.getUser().getLoginType();
		PaymentOrder order = new PaymentOrder();
		order.setMemberCode(member.getMemberCode());
		order.setMemberName(member.getName());
		order.setAddTime(new Date());
		//来自合作机构的订单
		order.setSource(loginType);
		order.setOrderCode(SysCodeUtil.getPayRunningNumberWithMemberCode(member.getMemberCode()));
		return order;
	}

	
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> groomerRegisterToOrder(String memberCode,String groomerRegisterId) {
		Member member = memberService.getByMemberCode(memberCode);
		//设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(member);
		//构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildGroomerRegisterPaymentOrderDetailList(paymentOrder,member,groomerRegisterId);
		//计算订单总额
		Double orderTotal = 0d;
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
		}
		//保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		//回写订单详情的OrderCode字段
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		//保存订单详情
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		//更新业务表不为空且不为会员表的收费项
		//更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			//更新业务表不为空且不为会员表的收费项
			if(StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())&&!"sys_member".equals(paymentOrderDetail.getBusinessTable())&&!"kennel".equals(paymentOrderDetail.getBusinessTable())){
				String businessIds = paymentOrderDetail.getBusinessIds();
				if(businessIds.contains(",")){
					String[] bids = businessIds.split(",");
					for(int j=0;j<bids.length;j++){
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				}else{
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrderDetailList;
	}
	/**
	 * 生成美容会员缴费订单及详情
	 * @Author chaixueteng
	 * @2017年6月22日上午10:44:56
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> DiplomaToOrder(String memberCode,String diplomaId) {
		Member member = memberService.getByMemberCode(memberCode);
		//原本有订单就使用原来的订单
		boolean isNewOrder = true ;
		GroomerDiploma groomerDiploma = groomerDiplomaService.get(diplomaId);
		if(StringUtils.isNotBlank(groomerDiploma.getRunningNumber())) {
			PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(groomerDiploma.getRunningNumber());
			if(Objects.nonNull(paymentOrder) && !Objects.equals("1", paymentOrder.getDelFlag())) {
				isNewOrder = false ;
			}
		}
		List<PaymentOrderDetail> paymentOrderDetailList = null;
		if(isNewOrder) {
			//设置订单基本字段
			PaymentOrder paymentOrder = buildPaymentOrder(member);
			//构造订单详情列表
			paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder,member,"diploma",diplomaId);
			//计算订单总额
			Double orderTotal = 0d;
			for(PaymentOrderDetail detail:paymentOrderDetailList){
				orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
			}
			//保存订单
			restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
			//回写订单详情的OrderCode字段
			for(PaymentOrderDetail detail:paymentOrderDetailList){
				detail.setOrderCode(paymentOrder.getOrderCode());
			}
			//保存订单详情
			for(PaymentOrderDetail detail:paymentOrderDetailList){
				detail.preInsert();
				paymentOrderDetailDao.insert(detail);
			}
			//更新业务表不为空且不为会员表的收费项
			//更新业务表流水号
			for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
				//更新业务表不为空且不为会员表的收费项
				if(StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())&&!"sys_member".equals(paymentOrderDetail.getBusinessTable())&&!"kennel".equals(paymentOrderDetail.getBusinessTable())){
					String businessIds = paymentOrderDetail.getBusinessIds();
					if(businessIds.contains(",")){
						String[] bids = businessIds.split(",");
						for(int j=0;j<bids.length;j++){
							paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), bids[j]);
						}
					}else{
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), businessIds);
					}
				}
			}
		}else {
			//查询旧订单
			paymentOrderDetailList = paymentOrderDetailDao.findByOrderCode(groomerDiploma.getRunningNumber());
		}
		
		
		return paymentOrderDetailList;
	}

	

	/**
	 * 余额支付
	 * @Author chaixueteng
	 * @2017年6月22日上午11:26:15
	 */
	@Transactional(readOnly = false)
	public String paymentSchoolsOrder(String paymentWay, String orderId) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		//判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.getByIdForUpdate(orderId);
		if(order != null && order.getPaymentState().equals("1")){
			order.setPaymentWay("25");//25代表余额支付
			memberService.memberCharge(ti.getSchoolMemberCode(),order.getTotalPrice(),order.getOrderCode());
			restOrderService.afterPay(order);
		}
		return "redirect:/schools/schoolsMember/list?repage";
	}


	/**
	 * 更改订单支付方式
	 * @param orderId
	 * @param paymentWay
	 */
	@Transactional(readOnly = false)
	public void updateOrderWay(String orderId, String paymentWay) {
		PaymentOrder paymentOrder = paymentOrderService.get(orderId);
		if(StringUtils.isNotBlank(paymentOrder.getPaymentWay())){
			if(!paymentOrder.getPaymentWay().equals(paymentWay)){
				paymentOrder.setPaymentWay(paymentWay);
			}
		}else{
			paymentOrder.setPaymentWay(paymentWay);
		}
		paymentOrderDao.update(paymentOrder);
	}


	/**
	 * 学校续费
	 * @Author chaixueteng
	 * @2017年6月28日下午1:19:22
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> schoolRenew(String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		//设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(member);
		//构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildSchoolPaymentOrderDetailList(paymentOrder,member);
		
		//计算订单总额
		Double orderTotal = 0d;
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
		}
		//保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		//回写订单详情的OrderCode字段
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		//保存订单详情
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		return  paymentOrderDetailList;
	}
	/**
	 * 构造学校续费订单详情
	 * @Author chaixueteng
	 * @2017年6月22日上午10:50:44
	 */
	private List<PaymentOrderDetail> buildSchoolPaymentOrderDetailList(
			PaymentOrder paymentOrder, Member member) {
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		PaymentChargingItem schoolItem = paymentChargingItemDao.getByShortName(MEMER_GROOMER_SCHOOL);
		Double schoolFee = Double.parseDouble(schoolItem.getPrice());//美容师预备会员费
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setOrderCode(paymentOrder.getOrderCode());
		detail.setAddTime(paymentOrder.getAddTime());
		detail.setProccessState("0");
		detail.setTotalPrice(schoolFee.toString());
		detail.setNum("1");
		detail.setPrice(schoolFee.toString());
		detail.setBusinessIds(member.getId());
		detail.setBusinessTable("sys_member");
		detail.setChargingItemId(schoolItem.getId());
		detail.setMemberCode(paymentOrder.getMemberCode());
		detail.setMemberName(paymentOrder.getMemberName());
		detail.setChargingItemName(schoolItem.getName()); 
		paymentOrderDetailList.add(detail);
		return paymentOrderDetailList;
	}
	
	
	/**
	 * 生成美容证书缴费订单及详情
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> certificateToOrder(GroomerQualificationCertificate groomerQualificationCertificate) {
		String memberCode = groomerQualificationCertificate.getMemberCode();
		String level = groomerQualificationCertificate.getLevelCn();
		String id = groomerQualificationCertificate.getId();
		Member member = memberService.getByMemberCode(memberCode);
		// 设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(member);
		// 构造订单详情列表
		String shortName = null;
		if (Objects.equals(groomerQualificationCertificate.getCertificateType(), "6")) {
			shortName = GROOMER_QUALIFICATION_CERTIFICATE_PDG;
		} else {
			if ("C".equals(level)) {
				shortName = GROOMER_QUALIFICATION_CERTIFICATE_C;
			} else if ("国际宠物美容师".equals(level)) {
				shortName = GROOMER_QUALIFICATION_CERTIFICATE_F;
			} else if ("PRIMARY".equals(level)
					|| "SENIOR".equals(level)
					|| "MATCH".equals(level)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE;
			}
		}
		PaymentChargingItem certificateItem = paymentChargingItemDao.getByShortName(shortName);
		double certificateFee = Double.parseDouble(certificateItem.getPrice());
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setOrderCode(paymentOrder.getOrderCode());
		detail.setAddTime(paymentOrder.getAddTime());
		detail.setProccessState("0");
		detail.setTotalPrice(Double.toString(certificateFee));
		detail.setNum("1");
		detail.setPrice(Double.toString(certificateFee));
		detail.setBusinessIds(id);
		detail.setBusinessTable("groomer_qualification_certificate");
		detail.setChargingItemId(certificateItem.getId());
		detail.setMemberCode(paymentOrder.getMemberCode());
		detail.setMemberName(paymentOrder.getMemberName());
		detail.setChargingItemName(certificateItem.getName());
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		paymentOrderDetailList.add(detail);
		return saveOrder(paymentOrder,paymentOrderDetailList);
	}

	private List<PaymentOrderDetail> saveOrder(PaymentOrder paymentOrder, List<PaymentOrderDetail> paymentOrderDetailList) {
		// 计算订单总额
		double orderTotal = 0d;
		for (PaymentOrderDetail d : paymentOrderDetailList) {
			orderTotal = orderTotal + Double.parseDouble(d.getTotalPrice());
		}
		// 保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		// 保存订单详情
		for (PaymentOrderDetail d : paymentOrderDetailList) {
			// 回写订单详情的OrderCode字段
			d.setOrderCode(paymentOrder.getOrderCode());
			d.preInsert();
			paymentOrderDetailDao.insert(d);
		}
		// 更新业务表不为空且不为会员表的收费项
		// 更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())
					&& !"sys_member".equals(paymentOrderDetail.getBusinessTable())
					&& !"kennel".equals(paymentOrderDetail.getBusinessTable())) {
				String businessIds = paymentOrderDetail.getBusinessIds();
				if (businessIds.contains(",")) {
					String[] bids = businessIds.split(",");
					for (String bid : bids) {
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
								paymentOrderDetail.getBusinessTable(), bid);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
							paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrderDetailList;
	}

}
