/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "优惠券接口--wj")
@Controller
@RequestMapping(value = "/api/v1/open/coupon")
public class OpenCouponController extends BaseRestController {

    @Autowired
    private SysCouponService sysCouponService;
    @Autowired
    private KennelService kennelService;

    @ApiOperation(value = "获取当前登录人的优惠券")
    @ApiImplicitParams({ @ApiImplicitParam(name = "type",paramType = "query", value = "优惠券类型")})
    @ApiResponses({ @ApiResponse(code = 0, message = "" +
            "{\n" +
            "  \"rc\": 0,\n" +
            "  \"msg\": \"OK\",\n" +
            "  \"data\": {\n" +
            "    \"couponCount\": \"1\",\n" +
            "    \"couponOnePrice\": \"50\"\n" +
            "  }\n" +
            "}")})
    @RequestMapping(value = "/getCoupon", method = RequestMethod.GET)
    @ResponseBody
    public void getCoupon(HttpServletRequest request, HttpServletResponse response) throws IOException {
        // 新增标记参数
        String type = request.getParameter("type");

        Map<String, String> map = new HashMap<>();
        map.put("couponCount", "0");
        map.put("couponOnePrice", "0");
        Member member = UserUtils.getLoginMember();
        // 查询是否可用优惠劵 犬舍保留期内申请的大于等于5张有效出生纸起
        Kennel k = kennelService.getKennelByMemberCode(member.getMemberCode());
        if (k != null/* &&k.getCalculationDate()!=null */) {// 犬舍必须是有核算日期的

            SysCoupon sysCoupon = new SysCoupon();
            sysCoupon.setMemberCode(member.getMemberCode());
            sysCoupon.setState("0");// 可用的
            List<SysCoupon> sList = sysCouponService.findCouponListByTarget(member.getMemberCode(), "0", type);
            if (sList.size() > 0) {
                map.put("couponCount", String.valueOf(sList.size()));
                map.put("couponOnePrice", sList.get(0).getFacePrice());
            }
			/* } */
        }
        ServletUtils.writeResponse(response, new RESTResponse("data", map));
    }

}