package com.cku.restful.v1.gcWeb.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanshuai
 * @date 2023/1/30 16:09
 */
@Data
@ApiModel
public class GCWebPageRequest implements Serializable {

	private static final long serialVersionUID = -8218343424534826995L;

	@ApiModelProperty("页码")
	@NotNull(message = "页码不能为空")
	public Integer pageNo;

	@ApiModelProperty("每页数量")
	@NotNull(message = "每页数量不能为空")
	public Integer pageSize;

	@ApiModelProperty("类型(1:关于2:讲座3:新闻4:合作机构5:友情链接6:考试大赛7:美容师人才库10:联系我们)")
	@NotNull(message = "类型不能为空")
	public Integer type;

	@ApiModelProperty("子类型（2::1美容讲座2:CKU专业培训,4::1:正式2:预备,6::1:规则,2:活动预告,3:活动回顾）")
	private Integer subType;
}
