package com.cku.restful.v1.gcWeb.service;

import com.cku.core.*;
import com.cku.oa.gcWeb.entity.*;
import com.cku.oa.gcWeb.service.*;
import com.cku.restful.v1.gcWeb.vo.*;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 美容官网
 *
 * @author yuanshuai
 * @date 2023/1/30 16:01
 */
@Service
public class RestGCWebService {

	@Autowired
	private GCWebBannerService gcWebBannerService;
	@Autowired
	private GCWebInfoService gcWebInfoService;
	@Autowired
	private GCWebContestService gcWebContestService;
	@Autowired
	private GCWebTalentService gcWebTalentService;
	@Autowired
	private GCWebFooterService gcWebFooterService;

	/**
	 * 轮播图列表查询
	 *
	 * @author yuanshuai
	 * @date 2023/1/31 10:28
	 */
	public ListResultDto<GCWebBannerResponse> findBanner() {
		GCWebBanner search = new GCWebBanner();
		search.setShowFlag(1);
		List<GCWebBanner> bannerList = gcWebBannerService.findList(search);
		return ListResultDto.success(bannerList.stream()
				.map(b -> {
					GCWebBannerResponse resp = GCWebBannerResponse.builder().build();
					BeanUtils.copyProperties(b, resp);
					return resp;
				})
				.collect(Collectors.toList()));
	}

	/**
	 * 分页查询
	 *
	 * @author yuanshuai
	 * @date 2023/1/30 16:30
	 */
	public PageResultDto<GCWebPageResponse> findPage(GCWebPageRequest request) {
		setUpPageParam(request);
		if (Objects.isNull(request.getType())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "类型不能为空");
		}
		List<GCWebPageResponse> respList = Lists.newArrayList();
		switch (request.getType()) {
			//考试大赛
			case 6:
				GCWebContest contest = new GCWebContest();
				contest.setShowFlag(1);
				contest.setType(request.getSubType());
				Page<GCWebContest> contestPage = gcWebContestService.findPage(new Page<>(request.getPageNo(), request.getPageSize()), contest);
				respList.addAll(contestPage.getList().stream()
						.map(s -> {
							GCWebPageResponse resp = GCWebPageResponse.builder().build();
							BeanUtils.copyProperties(s, resp);
							resp.setSubType(resp.getType());
							resp.setType(6);
							return resp;
						})
						.collect(Collectors.toList()));
				break;
			//美容师人才库
			case 7:
				GCWebTalent talent = new GCWebTalent();
				talent.setShowFlag(1);
				Page<GCWebTalent> talentPage = gcWebTalentService.findPage(new Page<>(request.getPageNo(), request.getPageSize()), talent);
				respList.addAll(talentPage.getList().stream()
						.map(s -> {
							GCWebPageResponse resp = GCWebPageResponse.builder().build();
							BeanUtils.copyProperties(s, resp);
							resp.setContent(s.getCv());
							resp.setType(7);
							return resp;
						})
						.collect(Collectors.toList()));
				break;
			//其他
			default:
				GCWebInfo info = new GCWebInfo();
				info.setShowFlag(1);
				info.setType(request.getType());
				info.setSubType(request.getSubType());
				Page<GCWebInfo> infoPage = gcWebInfoService.findPage(new Page<>(request.getPageNo(), request.getPageSize()), info);
				respList.addAll(infoPage.getList().stream()
						.map(s -> {
							GCWebPageResponse resp = GCWebPageResponse.builder().build();
							BeanUtils.copyProperties(s, resp);
							resp.setCreateDate(s.getCreateDate());
							return resp;
						})
						.collect(Collectors.toList()));
				break;
		}

		return PageResultDto.success(respList, (long) respList.size(), (long) ((respList.size() + request.getPageSize() - 1) / request.getPageSize()));
	}

	/**
	 * 初始化分页参数
	 *
	 * @author yuanshuai
	 * @date 2023/1/30 16:06
	 */
	public void setUpPageParam(GCWebPageRequest request) {
		int pageNo = 1;
		int pageSize = 10;
		if (Objects.isNull(request.getPageNo())) {
			request.setPageNo(pageNo);
		}
		if (Objects.isNull(request.getPageSize())) {
			request.setPageSize(pageSize);
		}
	}

	/**
	 * 详情查询
	 *
	 * @author yuanshuai
	 * @date 2023/1/30 17:47
	 */
	public ResultDto<GCWebDetailResponse> findDetail(GCWebDetailRequest request) {
		if (StringUtils.isBlank(request.getId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "ID不能为空");
		}
		if (Objects.isNull(request.getType())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "类型不能为空");
		}
		GCWebDetailResponse resp = GCWebDetailResponse.builder().build();
		switch (request.getType()) {
			//考试大赛
			case 6:
				GCWebContest source = gcWebContestService.get(request.getId());
				BeanUtils.copyProperties(source, resp);
				break;
			//美容师人才库
			case 7:
				GCWebTalent talent = gcWebTalentService.get(request.getId());
				BeanUtils.copyProperties(talent, resp);
				break;
			//其他
			default:
				GCWebInfo info = gcWebInfoService.get(request.getId());
				BeanUtils.copyProperties(info, resp);
				break;
		}
		return ResultDto.success(resp);
	}

	/**
	 * 底部信息查询
	 *
	 * @author yuanshuai
	 * @date 2023/1/30 17:36
	 */
	public ResultDto<GCWebFooterResponse> findFooter() {
		List<GCWebFooter> list = gcWebFooterService.findList(new GCWebFooter());
		GCWebFooter gcWebFooter = list.stream().findFirst().orElse(null);
		GCWebFooterResponse resp = GCWebFooterResponse.builder().build();
		if (Objects.nonNull(gcWebFooter)) {
			BeanUtils.copyProperties(gcWebFooter, resp);
		}
		return ResultDto.success(resp);
	}

}
