/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.entity.user.Member;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.modules.sys.dao.AreaDao;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @description: 城市
 * @author: laiguanglong
 * @date: 2017/10/16 10:25
 */
@Service
@Transactional(readOnly = true)
public class RestCityService {

    public static final List<String> PROVINCE_CITY_LIST = Lists.newArrayList("北京市", "上海市", "天津市", "重庆市");

    @Autowired
    private AreaDao areaDao;

    public RESTResponse hotCity() {
        List<JSONObject> list = Lists.newArrayList();
        JSONArray ja = new JSONArray();
        List<Dict> dictList = DictUtils.getDictList("hot_city");
        for (Dict dict : dictList) {
            ja.add(dict.getLabel());
        }
        return new RESTResponse("data", ja);
    }

    public RESTResponse city(HttpServletRequest request) {
        JSONArray ja = new JSONArray();
        String name = request.getParameter("name");
        List<Area> areaList = areaDao.getCityByName(name);
        for (Area area : areaList) {
            ja.add(area.getName());
        }
        if (StringUtils.isBlank(name)) {
            for (String provinceCity : PROVINCE_CITY_LIST) {
                ja.add(provinceCity);
            }
        } else {
            for (String provinceCity : PROVINCE_CITY_LIST) {
                if (provinceCity.contains(name)) {
                    ja.add(provinceCity);
                }
            }
        }
        return new RESTResponse("data", ja);
    }

    public String getCity(Member member) {
        String city = "";
        if (StringUtils.isNotBlank(member.getCity())) {
            if (StringUtils.isNotBlank(member.getProvince()) && PROVINCE_CITY_LIST.contains(member.getProvince())) {
                city = member.getProvince();
            } else {
                city = member.getCity();
            }
        }
        return city;
    }

}