package com.cku.partner.club.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.partner.club.entity.CompanionDogAppraisal;
import com.cku.partner.club.service.CompanionDogAppraisalService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.ZxingHandler;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 伴侣级鉴定Controller
 *
 * @author pp
 * @version 2019-07-04
 */
@Controller
@RequestMapping(value = "/partner/companionDogAppraisal")
public class CompanionDogAppraisalController extends BaseController {

    @Autowired
    public PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    private PaymentOrderService paymentOrderService;
    @Autowired
    private CompanionDogAppraisalService companionDogAppraisalService;

    @Autowired
    private OrgService orgService;

    @Autowired
    public DogBirthCertificateService dogBirthCertificateService;
    @Autowired
    public DogService dogService;
    
    /**
     * 伴侣级申请 交费
     *
     * @param cda
     * @param model
     * @param redirectAttributes
     * @return
     */
    @RequestMapping(value = "payment")
    public String payment(CompanionDogAppraisal cda, Model model, RedirectAttributes redirectAttributes) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        cda = companionDogAppraisalService.get(cda);
        List<PaymentOrderDetail> detailList;
        if (StringUtils.isBlank(cda.getRunningNumber())) {
            detailList = new ArrayList<>();
            PaymentOrderDetail o = companionDogAppraisalService.buildOrder(cda);
            detailList.add(o);
        } else {
            detailList = paymentOrderDetailDao.getOrderByRunningNum(cda.getRunningNumber(), org.getMember().getMemberCode());
        }
        PaymentOrder order = paymentOrderService.getByOrderCode(detailList.get(0).getOrderCode());
        model.addAttribute("orderId", order.getId());
        model.addAttribute("order", detailList);
        //重新查找  session域固定不变 所以需要重新查询 余额
        model.addAttribute("org", orgService.get(org.getId()));
        //跳转页面
        model.addAttribute("repage", "redirect:/partner/companionDogAppraisal");
        return "partner/sys/paymentPage";
    }

    @ModelAttribute
    public CompanionDogAppraisal get(@RequestParam(required = false) String id) {
        CompanionDogAppraisal entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = companionDogAppraisalService.get(id);
        }
        if (entity == null) {
            entity = new CompanionDogAppraisal();
        }
        return entity;
    }

    /**
     * 犬芯片号校验
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "verChipNo")
    public Object verChipNo(HttpServletRequest request, HttpServletResponse response) {
//        return companionDogAppraisalService.verChipNo(request);

        return companionDogAppraisalService.verCatDogChipNo(request);
    }

    /**
     * 猫芯片号校验
     *
     * @param request
     * @param response
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "verCatChipNo")
    public Object verCatChipNo(HttpServletRequest request, HttpServletResponse response) {
//        return companionDogAppraisalService.verCatChipNo(request);
        return companionDogAppraisalService.verCatDogChipNo(request);
    }

    /**
     * 获取二维码
     *
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "getQRCode")
    public String getQRCode(HttpServletRequest request, HttpServletResponse response, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        String pathName = Global.getConfig("file.dir") + "/QRCode/" + org.getId() + ".png";
        String cont = Global.getConfig("RCodeUrl") + org.getId() + "&orgid=" + org.getId();
        ZxingHandler.encode2(
                cont,
                600,
                600,
                pathName);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(pathName));
            byte[] b = new byte[fis.available()];
            fis.read(b);
            model.addAttribute("data", com.alibaba.druid.util.Base64.byteArrayToBase64(b));
        } catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("msg", "生成二维码异常");
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "partner/club/companionDogAppraisalQRCode";
    }

    //	@RequiresPermissions("club:companionDogAppraisal:view")
    @RequestMapping(value = {"list", ""})
    public String list(CompanionDogAppraisal companionDogAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
        companionDogAppraisal.setOrgId(org.getId());
        Page<CompanionDogAppraisal> page = companionDogAppraisalService.findPage(new Page<CompanionDogAppraisal>(request, response), companionDogAppraisal);
//        List<CompanionDogAppraisal> list = page.getList();
//        for (CompanionDogAppraisal com : list) {
//            if ("1".equals(com.getIdentitySticker()) && StringUtils.isNotBlank(com.getIdentitySticker())
//                    && com.getIdentityPrintTime() != null && new Date().getTime() <= DateUtils.addDays(com.getIdentityPrintTime(), 1).getTime()) {
//                com.setIdentitySticker("2");
//            }
//            if ("1".equals(com.getGradeSticker()) && StringUtils.isNotBlank(com.getGradeSticker())
//                    && com.getGradePrintTime() != null && new Date().getTime() <= DateUtils.addDays(com.getGradePrintTime(), 1).getTime()) {
//                com.setGradeSticker("2");
//            }
//        }
        model.addAttribute("page", page);
        return "partner/club/companionDogAppraisalList";
    }

    /**
     * 根据芯片号或者id查找 伴侣级信息
     *
     * @param request
     * @param response
     * @return
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping(value = "getByIdentificationFlag")
    public Object getByIdentificationFlag(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return companionDogAppraisalService.getByIdentificationFlag(request, response);
    }

    //	@RequiresPermissions("club:companionDogAppraisal:view")
    @RequestMapping(value = "form")
    public String form(CompanionDogAppraisal companionDogAppraisal, Model model) {
        Org org = (Org) UserUtils.getSession().getAttribute("org");
//        Map<String, String> map = new HashMap<>();
//        if (StringUtils.isNotEmpty(org.getJianDingshi1()))
//            map.put(org.getJianDingshi1(), org.getJianDingshi1());
//        if (StringUtils.isNotEmpty(org.getJianDingshi2()))
//            map.put(org.getJianDingshi2(), org.getJianDingshi2());
        companionDogAppraisalService.getCatClorMark();
        Map<String, String> lstColor = new HashMap<>();
        if ("0".equals(companionDogAppraisal.getPetType()))
            lstColor = companionDogAppraisalService.getDogClorMark();
        if ("1".equals(companionDogAppraisal.getPetType()))
            lstColor = companionDogAppraisalService.getCatClorMark();
        if (StringUtils.isNotEmpty(companionDogAppraisal.getPetColor())) {
            if (!lstColor.containsKey(companionDogAppraisal.getPetColor())) {
                companionDogAppraisal.setPetColorO(companionDogAppraisal.getPetColor());
                companionDogAppraisal.setPetColor("0");
            }
        }
        companionDogAppraisal.setOrgId(org.getId());
        companionDogAppraisal.setAppraisalProvince(org.getProvince());
        companionDogAppraisal.setAppraisalCity(org.getCity());
        companionDogAppraisal.setAppraisalShop(org.getName());
        model.addAttribute("companionDogAppraisal", companionDogAppraisal);
        model.addAttribute("postalProvince", UserUtils.getProvince());
        model.addAttribute("postalCity", UserUtils.getCityByProvince(companionDogAppraisal.getPostalProvince()));
//        model.addAttribute("postalCity2", UserUtils.getCityByProvince(companionDogAppraisal.getAppraisalProvince()));
        model.addAttribute("petColor", lstColor);
//        model.addAttribute("appraisalLst", map);
//        Org o = new Org();
//        o.setProvince(org.getProvince());
//        o.setCity(org.getCity());
//        model.addAttribute("appraisalShop", clubOrgService.findList(o));
        return "partner/club/companionDogAppraisalForm";
    }


    @ResponseBody
    @RequestMapping(value = "getPetColor")
    public Object getPetColor(HttpServletRequest request, HttpServletResponse response) {
        return companionDogAppraisalService.getDogClorMark();
    }

    @ResponseBody
    @RequestMapping(value = "getPetCatColor")
    public Object getPetCatColor(HttpServletRequest request, HttpServletResponse response) {
        return companionDogAppraisalService.getCatClorMark();
    }

    //	@RequiresPermissions("club:companionDogAppraisal:edit")
    @RequestMapping(value = "save")
    public String save(CompanionDogAppraisal companionDogAppraisal, Model model, RedirectAttributes redirectAttributes) {

        Org org = (Org) UserUtils.getSession().getAttribute("org");

        companionDogAppraisal.setAppraisalProvince(org.getProvince());
        companionDogAppraisal.setAppraisalCity(org.getCity());
        companionDogAppraisal.setAppraisalShop(org.getName());
        if ("0".equals(companionDogAppraisal.getPetColor()))
            companionDogAppraisal.setPetColor(companionDogAppraisal.getPetColorO());
        if (StringUtils.isEmpty(companionDogAppraisal.getAppraisal()))
            companionDogAppraisal.setAppraisal(companionDogAppraisal.getAppraisalL());
        if (!beanValidator(model, companionDogAppraisal)) {
            return form(companionDogAppraisal, model);
        }
        Map<String, String> map = companionDogAppraisalService.verCatDogChipNo(
                companionDogAppraisal.getIdentificationFlag(),
                "",
                companionDogAppraisal.getId(),
                companionDogAppraisal.getChipType());
        if (map != null && map.get("rc").equals("-1")) {
            addMessage(model, map.get("msg"));
            return form(companionDogAppraisal, model);
        }

        if ("1".equals(companionDogAppraisal.getAppraisalResult())) {
            companionDogAppraisal.setAppraisalDate(new Date());
            int random = (int) (Math.random() * 1000000);
            companionDogAppraisal.setPassportNo(String.valueOf(random));
        }
        if (StringUtils.isNotBlank(companionDogAppraisal.getId())) {
            Map<String, String> cabCode = companionDogAppraisalService.createCabCode(companionDogAppraisal);
            companionDogAppraisal.setPassportNo(cabCode.get("passportNo"));
            companionDogAppraisal.setCabRegisterCode(cabCode.get("cabRegisterCode"));
            companionDogAppraisal.setClassCode(cabCode.get("classCode"));
        }
        companionDogAppraisal.setOrgId(org.getId());
        companionDogAppraisalService.save(companionDogAppraisal);
        addMessage(redirectAttributes, "保存伴侣级鉴定成功");
        return "redirect:/partner/companionDogAppraisal/?repage";
    }

    //	@RequiresPermissions("club:companionDogAppraisal:edit")
    @RequestMapping(value = "delete")
    public String delete(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        companionDogAppraisalService.delete(companionDogAppraisal);
        addMessage(redirectAttributes, "删除伴侣级鉴定成功");
        return "redirect:/partner/companionDogAppraisal/?repage";
    }

    /**
     * 身份贴纸打印
     *
     * @param companionDogAppraisal
     * @param redirectAttributes
     * @return
     */
    @RequestMapping(value = "identityPrint")
    public String identityPrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        try {
            return companionDogAppraisalService.identityPrint(companionDogAppraisal.getId());

        } catch (ZAException e) {
            logger.warn("打印出错", e);
            addMessage(redirectAttributes, "打印出错:" + e.getMessage());
            return "redirect:/partner/companionDogAppraisal/?repage";
        }
    }

    /**
     * 等级贴纸打印
     *
     * @param companionDogAppraisal
     * @param redirectAttributes
     * @return
     */
    @RequestMapping(value = "gradePrint")
    public String gradePrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        try {
            return companionDogAppraisalService.gradePrint(companionDogAppraisal.getId());
        } catch (ZAException e) {
            logger.warn("打印出错", e);
            addMessage(redirectAttributes, "打印出错:" + e.getMessage());
            return "redirect:/partner/companionDogAppraisal/?repage";
        }
    }

    @RequestMapping(value = "restIdentityPrint")
    public String restIdentityPrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        companionDogAppraisalService.restIdentityPrint(companionDogAppraisal.getId());
        addMessage(redirectAttributes, "打印重置成功");
        return "redirect:/partner/companionDogAppraisal/?repage";
    }

    @RequestMapping(value = "restGradePrint")
    public String restGradePrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        companionDogAppraisalService.restGradePrint(companionDogAppraisal.getId());
        addMessage(redirectAttributes, "打印重置成功");
        return "redirect:/partner/companionDogAppraisal/?repage";
    }

}