package com.cku.partner.club.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareAuditService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * user chaixueteng 2016年10月10日
 */
@Service
@Transactional(readOnly = true)
public class ClubDnaService {

	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public OrgService orgService;
	@Autowired
	public OrgDogTypeLimitService orgDogTypeLimitService;
	@Autowired
	public DogBloodSaveService dogBloodSaveService;
	@Autowired
	public DogChipChangeDao dogChipChangeDao;
	@Autowired
	public MemberDao memberDao;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private ClubMemberService clubMemberService;
	@Autowired
	private DogDnaParentsCompareAuditService dogDnaParentsCompareAuditService;

	private static final String BLOOD_SAVE_FEE = "dog_blood_save@New";// 血样费
	public static final String BLOOD_SAVE_FEE_MIAN_FEI = "dog_blood_save_fee@New";// 血样免费
	private static final String DNA_ARCHIVE_FEE = "dog_dna_archive@New";// 位点分析费用

	/**
	 * 血统证书号/芯片号查询
	 *
	 * @Author chaixueteng
	 * @2017年9月6日下午4:32:23
	 */
	public Map<String, String> searchDnaMessage(String pedigreeCertifiedCode) throws ZAException {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		Map<String, String> map = new HashMap<String, String>();
		// 判断是否已有留存记录
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog == null) {// 通过芯片查询
			dog = dogService.getByIdentificationFlag(pedigreeCertifiedCode);
			if (dog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无查询结果!");
			}
		}
		clubMemberService.checkOrgSite(org,dog.getDogBreed());
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), dog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
		}
		// 判断是否为单犬种会员
		if ("singleTypeClub".equals(org.getOrgType())) {
			// 繁育人
			Member breederMember = memberService.singleMember(dog.getBreederMemberCode(), org.getUser().getLoginName());
			// 新犬主
			Member singleMember = memberService.singleMember(dog.getMemberCode(),
					org.getUser().getLoginName());

			if (!(breederMember != null
					|| (StringUtils.isBlank(dog.getBreederMemberCode()) ? "" : dog.getBreederMemberCode())
							.equals(org.getAdminCode())
					|| singleMember != null || dog.getMemberCode().equals(org.getAdminCode()))) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
			}
		}

//		if("singleTypeClub".equals(org.getOrgType()) && !(dog.getMemberCode().equals(org.getAdminCode())) ) {
//			Member sigleMember = memberService.singleMember(dog.getMemberCode(), org.getUser().getLoginName());
//			if (sigleMember == null) {
//				throw new ZAException(ZAErrorCode.ZA_ERROR, "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
//			}
//		}

		// 判断犬只状态
		String dogState = dog.getDogState();
		if (!"0".equals(dogState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只状态非正常!");
		}
		DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByPediCodeOrChipCode(pedigreeCertifiedCode);
		if (dogDnaArchive != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有DNA存档记录!");
		}
		// 判断是否有血样记录
		DogBloodSave bloodSave = null;
		if (StringUtils.isNotBlank(dog.getBirthCertificateLevelCode())) {
			bloodSave = dogBloodSaveService.getByBirthCode(dog.getBirthCertificateLevelCode());
		} else if (StringUtils.isNotBlank(dog.getPedigreeCertifiedEn())) {
			bloodSave = dogBloodSaveService.getByOverPedigreeCode(dog.getPedigreeCertifiedEn());
		}
		if (bloodSave == null) {
			map.put("havaBlood", "0");
		} else {
			map.put("havaBlood", "1");
		}
		map.put("dogName", dog.getNameEn());
		if (StringUtils.isNotBlank(dog.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
			map.put("dogBreed", dogType.getBreedCnName());
		}
		map.put("dogOwnerCode", dog.getMemberCode());
		map.put("dogOwner", dog.getDogOwner());
		map.put("dogId", dog.getId());
		return map;
	}

	/**
	 * 提交DNA位点分析
	 *
	 * @Author chaixueteng
	 * @2017年9月7日上午11:12:47
	 */
	@Transactional(readOnly = false)
	public void add(String dogId, String havaBlood,String dna,String dnayes,String samplingCode) {
		Dog dog = dogService.get(dogId);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询的血统证书或芯片有误!");
		}
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), dog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
		}
		DogBloodSave bloodSave = null;
		if (StringUtils.isNotBlank(dog.getBirthCertificateLevelCode())) {
			bloodSave = dogBloodSaveService.getByBirthCode(dog.getBirthCertificateLevelCode());
		} else if (StringUtils.isNotBlank(dog.getPedigreeCertifiedEn())) {
			bloodSave = dogBloodSaveService.getByOverPedigreeCode(dog.getPedigreeCertifiedEn());
		}
		if ("1".equals(dna)) {
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByPediCodeOrChipCode(dog.getPedigreeCertifiedCode());
			if (dogDnaArchive != null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有DNA存档记录!");
			}
			DogBloodSave buildDogBloodSave = null;
			if (Objects.isNull(bloodSave)) {
				buildDogBloodSave = buildDogBloodSave(dog, dnayes, dna);
			}
			DogDnaArchive buildDogDnaArchive = buildDogDnaArchive(dog, dnayes);
			if(StringUtils.isBlank(samplingCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "位点分析必须绑定采样包!");
			}
			dogDnaArchiveService.bindSamplingFront(dog.getPedigreeCertifiedCode(),SamplingDogSourceTypeEnum.PEDIGREE_CERTIFIED,
					samplingCode, org.getMemberCode());
			// 生成未支付订单
			addToOrder(buildDogDnaArchive, buildDogBloodSave);
		} else {
			// 判断是否有血样记录
			if (bloodSave != null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有血样留存记录!");
			}
			//血样留存
			DogBloodSave buildDogBloodSave = buildDogBloodSave(dog, dnayes, dna);
			// 生成未支付订单
			addToOrderDogBloodSave(buildDogBloodSave);
		}
	}

	/**
	 * 构建 位点分析记录
	 *
	 * @Author chaixueteng
	 * @2017年9月7日上午11:16:12
	 */
	@Transactional(readOnly = false)
	public DogDnaArchive buildDogDnaArchive(Dog dog,String dnayes) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		DogDnaArchive dogDnaArchive = new DogDnaArchive();
		dogDnaArchive.setDogId(dog.getId());
		dogDnaArchive.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		dogDnaArchive.setOverseasPedigreeCertified(dog.getPedigreeCertifiedEn());
		dogDnaArchive.setBirthCode(dog.getBirthCertificateLevelCode());
		dogDnaArchive.setPaymentMemberCode(dog.getMemberCode());
		dogDnaArchive.setOperator("");
		dogDnaArchive.setPrice("400");
		dogDnaArchive.setPaymentState("1");
		dogDnaArchive.setReviewState("0");
		dogDnaArchive.setProcessState("0");
		dogDnaArchive.setIsCanceled("0");
		dogDnaArchive.setPrintState("0");
		dogDnaArchive.setOrgId(org.getId());
		dogDnaArchive.setTypeYes(dnayes);
		dogDnaArchive.setIsOEC("1"); // 是否为口腔上皮细胞测试法:否0；是1
		dogDnaArchiveService.save(dogDnaArchive);
		return dogDnaArchive;
	}

	/**
	 * 构建 血样留存记录
	 *
	 * @Author chaixueteng
	 * @2017年9月7日上午11:16:12
	 */
	@Transactional(readOnly = false)
	public DogBloodSave buildDogBloodSave(Dog dog,String dnayes,String dna) {
		DogBloodSave dogBloodSave = new DogBloodSave();
		dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		dogBloodSave.setOverseasPedigreeCertified(dog.getPedigreeCertifiedEn());
		dogBloodSave.setBirthCode(dog.getBirthCertificateLevelCode());
		dogBloodSave.setPaymentMemberCode(dog.getMemberCode());
		dogBloodSave.setPaymentState("1");
		dogBloodSave.setPrice("100");
		dogBloodSave.setIsCanceled("0");
		dogBloodSave.setTypeYes(dnayes);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		dogBloodSave.setOrgId(org.getId());
		dogBloodSave.setIsOEC("1".equals(dna) ?"1":"0" );
		dogBloodSaveService.save(dogBloodSave);


		return dogBloodSave;
	}

	public List<PaymentOrderDetail> toOrder(DogDnaArchive dogDnaArchive) {
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
		//位点分析
			String runningNumber = dogDnaArchive.getRunningNumber();
			PaymentOrder order = null;
			if (StringUtils.isNotBlank(runningNumber)) {
				order = paymentOrderDao.getOrderByRunningNum(runningNumber);
			}
			if (order == null) {// 订单不存在或者已经被删除了
//				String birthCode = dogDnaArchive.getBirthCode();
//				DogBloodSave dogBloodSave = null;
//				if (StringUtils.isBlank(birthCode)) {
//					String overseasPedigreeCertified = dogDnaArchive.getOverseasPedigreeCertified();
//					dogBloodSave = dogBloodSaveService.getByOverPedigreeCode(overseasPedigreeCertified);
//				} else {
//					dogBloodSave = dogBloodSaveService.getByBirthCode(birthCode);
//				}
//				list = addToOrder(dogDnaArchive, dogBloodSave);
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单不存在或者已经被删除了!");
			} else {
				list = paymentOrderDetailDao.getOrderByRunningNum(runningNumber, dogDnaArchive.getPaymentMemberCode());
			}

		return list;
	}
	public List<PaymentOrderDetail> toOrder(DogBloodSave dogBloodSave) {
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
			//血样留存
			String runningNumber = dogBloodSave.getRunningNumber();
			PaymentOrder order = null;
			if (StringUtils.isNotBlank(runningNumber)) {
				order = paymentOrderDao.getOrderByRunningNum(runningNumber);
			}
			if (order == null) {// 订单不存在或者已经被删除了
				// addToOrderDogBloodSave(dogBloodSave);
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单不存在或者已经被删除了!");
			}else{
				list = paymentOrderDetailDao.getOrderByRunningNum(runningNumber, dogBloodSave.getPaymentMemberCode());
			}

		return list;
	}
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> addToOrder(DogDnaArchive buildDogDnaArchive, DogBloodSave buildDogBloodSave) {
		// 设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(buildDogDnaArchive);
		// 构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder, buildDogDnaArchive,
				buildDogBloodSave);
		// 计算订单总额
		Double orderTotal = 0d;
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			orderTotal = orderTotal + Double.parseDouble(detail.getTotalPrice());
		}
		// 保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		// 回写订单详情的OrderCode字段
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		// 保存订单详情
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		// 更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())
					&& !"sys_member".equals(paymentOrderDetail.getBusinessTable())
					&& !"kennel".equals(paymentOrderDetail.getBusinessTable())) {
				String businessIds = paymentOrderDetail.getBusinessIds();
				if (businessIds.contains(",")) {
					String[] bids = businessIds.split(",");
					for (int j = 0; j < bids.length; j++) {
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
								paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
							paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrderDetailList;
	}
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> addToOrderDogBloodSave(DogBloodSave buildDogBloodSave) {
		// 设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(buildDogBloodSave);
		// 构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailListT(paymentOrder, buildDogBloodSave);
		// 计算订单总额
		Double orderTotal = 0d;
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			orderTotal = orderTotal + Double.parseDouble(detail.getTotalPrice());
		}
		// 保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		// 回写订单详情的OrderCode字段
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		// 保存订单详情
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		// 更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())
					&& !"sys_member".equals(paymentOrderDetail.getBusinessTable())
					&& !"kennel".equals(paymentOrderDetail.getBusinessTable())) {
				String businessIds = paymentOrderDetail.getBusinessIds();
				if (businessIds.contains(",")) {
					String[] bids = businessIds.split(",");
					for (int j = 0; j < bids.length; j++) {
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
								paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(),
							paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrderDetailList;
	}
	/**
	 *
	 * @description: 设置订单基本字段
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午7:21:55
	 */
	private PaymentOrder buildPaymentOrder(DogDnaArchive buildDogDnaArchive) {
		PaymentOrder order = new PaymentOrder();
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		Member member = org.getMember();
		Member byMemberCode = memberService.getByMemberCode(buildDogDnaArchive.getPaymentMemberCode());
		order.setMemberCode(buildDogDnaArchive.getPaymentMemberCode());
		order.setMemberName(byMemberCode.getName());
		order.setAddTime(new Date());
		order.setSource(member.getLoginType());
		return order;
	}

	private PaymentOrder buildPaymentOrder(DogBloodSave buildDogBloodSave) {
		PaymentOrder order = new PaymentOrder();
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		Member member = org.getMember();
		Member byMemberCode = memberService.getByMemberCode(buildDogBloodSave.getPaymentMemberCode());
		order.setMemberCode(buildDogBloodSave.getPaymentMemberCode());
		order.setMemberName(byMemberCode.getName());
		order.setAddTime(new Date());
		order.setSource(member.getLoginType());
		return order;
	}

	/**
	 *
	 * @description: 构造订单详情列表
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午7:22:16
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> buildPaymentOrderDetailList(PaymentOrder paymentOrder,
			DogDnaArchive buildDogDnaArchive, DogBloodSave buildDogBloodSave) {
		if (buildDogDnaArchive == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA位点分析记录有误!");
		}
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		//位点分析收费项
		List<PaymentChargingItem> paymentChargingItems = dogDnaArchiveService.getDnaArchiveItem();
		paymentChargingItems.stream().forEach(paymentChargingItem->{
			PaymentOrderDetail detail1 = new PaymentOrderDetail();
			detail1.setAddTime(paymentOrder.getAddTime());
			detail1.setProccessState("0");
			detail1.setTotalPrice(paymentChargingItem.getPrice());
			detail1.setNum("1");
			detail1.setPrice(paymentChargingItem.getPrice());
			detail1.setBusinessIds(buildDogDnaArchive.getId());
			detail1.setBusinessTable("dog_dna_archive");
			detail1.setChargingItemId(paymentChargingItem.getId());
			detail1.setMemberCode(paymentOrder.getMemberCode());
			detail1.setMemberName(paymentOrder.getMemberName());
			detail1.setChargingItemName(paymentChargingItem.getName());
			paymentOrderDetailList.add(detail1);
		});
		if (buildDogBloodSave != null) {
			// 登记服务费(纯种犬DNA样本)
			PaymentChargingItem item = paymentChargingItemService.getByShortName(RestDogChipService.BLOOD_SAVE_FEE_OEC);
			PaymentOrderDetail detail2 = new PaymentOrderDetail();
			detail2.setAddTime(paymentOrder.getAddTime());
			detail2.setProccessState("0");
			detail2.setTotalPrice(item.getPrice());
			detail2.setNum("1");
			detail2.setPrice(item.getPrice());
			detail2.setBusinessIds(buildDogBloodSave.getId());
			detail2.setBusinessTable("dog_blood_save");
			detail2.setChargingItemId(item.getId());
			detail2.setMemberCode(paymentOrder.getMemberCode());
			detail2.setMemberName(paymentOrder.getMemberName());
			detail2.setChargingItemName(item.getName());
			paymentOrderDetailList.add(detail2);
		}
		return paymentOrderDetailList;
	}
	/**
	 *
	 * @description: 构造订单详情列表
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午7:22:16
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> buildPaymentOrderDetailListT(PaymentOrder paymentOrder,
																  DogBloodSave buildDogBloodSave) {
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		// 登记服务费(纯种犬DNA样本)
		if (buildDogBloodSave != null) {
			PaymentChargingItem item = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE);
			PaymentOrderDetail detail2 = new PaymentOrderDetail();
			detail2.setAddTime(paymentOrder.getAddTime());
			detail2.setProccessState("0");
			detail2.setTotalPrice(item.getPrice());
			detail2.setNum("1");
			detail2.setPrice(item.getPrice());
			detail2.setBusinessIds(buildDogBloodSave.getId());
			detail2.setBusinessTable("dog_blood_save");
			detail2.setChargingItemId(item.getId());
			detail2.setMemberCode(paymentOrder.getMemberCode());
			detail2.setMemberName(paymentOrder.getMemberName());
			detail2.setChargingItemName(item.getName());
			paymentOrderDetailList.add(detail2);
		}

		if(buildDogBloodSave !=null){
			//生成登记服务费（纯种犬DNA样本）减免
			PaymentChargingItem item = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE_MIAN_FEI);
			PaymentOrderDetail detail2 = new PaymentOrderDetail();
			detail2.setAddTime(paymentOrder.getAddTime());
			detail2.setProccessState("0");
			detail2.setTotalPrice(item.getPrice());
			detail2.setNum("1");
			detail2.setPrice(item.getPrice());
			detail2.setBusinessIds(buildDogBloodSave.getId());
			detail2.setBusinessTable("dog_blood_save");
			detail2.setChargingItemId(item.getId());
			detail2.setMemberCode(paymentOrder.getMemberCode());
			detail2.setMemberName(paymentOrder.getMemberName());
			detail2.setChargingItemName(item.getName());
			paymentOrderDetailList.add(detail2);
		}
		return paymentOrderDetailList;
	}
	
	@Transactional(readOnly = false)
	public void delete(String type, String id) {
		if (type.equals("1")) {// 位点
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.get(id);
			dogDnaArchiveService.delete(dogDnaArchive);
			// 根据订单编号查询是否有血样留存数据
			if (StringUtils.isNotBlank(dogDnaArchive.getRunningNumber())) {
				// 删除
				DogBloodSave byRunningMumber = dogBloodSaveService.getByRunningMumber(dogDnaArchive.getRunningNumber());
				if (byRunningMumber != null) {
					dogBloodSaveService.delete(byRunningMumber);
				}
			}
		}
		if (type.equals("2")) {// 血样
			DogBloodSave dogBloodSave = dogBloodSaveService.get(id);
			dogBloodSaveService.delete(dogBloodSave);
		}
	}
	
	@Transactional(readOnly = false)
	public void saveDogDnaArchive(String dnayes,String id,String samplingCode) {
		// 位点分析
		DogDnaArchive dogDnaArchive = dogDnaArchiveService.get(id);
		dogDnaArchive.setTypeYes(dnayes);
		if ("2".equals(dnayes)) {
			dogDnaArchive.setFinishTime(new Date());
		}
		//位点分析本身就有采样包不走绑定了
		if(!StringUtils.isNotBlank(dogDnaArchive.getSamplingCode())) {
			if("1".equals(dogDnaArchive.getIsOEC())&&StringUtils.isBlank(samplingCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "位点分析必须绑定采样包");
			}
			// 是否含有双亲对比项目，含有的需要验证父母双方是否同意
			if (StringUtils.isNotBlank(dogDnaArchive.getRunningNumber()) ){
				dogDnaParentsCompareAuditService.cherkByOrderCode(dogDnaArchive.getRunningNumber(),
						dogDnaArchive.getPedigreeCertified());
			}
			// 绑定采样包
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			dogDnaArchiveService.bindSamplingFront(dogDnaArchive,samplingCode, org.getMemberCode());
		}
		dogDnaArchiveService.save(dogDnaArchive);
		// isoec=1 口腔上皮细胞检测的血样留存跟位点分析一起完成
		if ("1".equals(dogDnaArchive.getIsOEC())) {
			DogBloodSave dogBloodSave = dogBloodSaveService.getOneByParam(dogDnaArchive.getBirthCode(), dogDnaArchive.getOverseasPedigreeCertified(),
					null, dogDnaArchive.getPedigreeCertifiedCode());
			if("1".equals(dogBloodSave.getIsOEC())) {
				dogBloodSave.setTypeYes(dnayes);
				if ("2".equals(dnayes)) {
					dogBloodSave.setFinishTime(new Date());
				}
				dogBloodSaveService.save(dogBloodSave);
			}
		}
	}
	
	
}