/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.tcb.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.tcb.entity.TcbKennel;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 淘宠宝犬舍DAO接口
 * @author lgl
 * @version 2017-02-21
 */
@MyBatisDao
public interface TcbKennelDao extends CrudDao<TcbKennel> {
    //根据会员号查询有效记录条数
    int countByMemberCode(@Param("memberCode")String memberCode);
    //根据合同号查询有效记录条数
    int countByContractCode(@Param("contractCode")String contractCode);
    //根据会员号获取淘宠宝犬舍信息
    TcbKennel getByMemberCode(@Param("memberCode")String memberCode);
    
    List<TcbKennel> getByMemberCodes(@Param("memberCodes")List<String> memberCodes);
}