package com.cku.oa.show.service;

import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.entity.ShowHotel;
import com.cku.oa.show.dao.ShowHotelDao;

/**
 * 赛事酒店Service
 * @author cxt
 * @version 2017-08-02
 */
@Service
@Transactional(readOnly = true)
public class ShowHotelService extends CrudService<ShowHotelDao, ShowHotel> {

	public ShowHotel get(String id) {
		return super.get(id);
	}
	
	public List<ShowHotel> findList(ShowHotel showHotel) {
		return super.findList(showHotel);
	}
	
	public Page<ShowHotel> findPage(Page<ShowHotel> page, ShowHotel showHotel) {
		return super.findPage(page, showHotel);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowHotel showHotel) {
		if (StringUtils.isNotBlank(showHotel.getHotelInfo())) {
			showHotel.setHotelInfo(StringEscapeUtils.unescapeHtml4(showHotel.getHotelInfo()));
		}
		super.save(showHotel);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowHotel showHotel) {
		super.delete(showHotel);
	}

	/**
	 * 查找所有赛事酒店
	 * @Author chaixueteng
	 * @2017年8月2日下午5:39:51
	 */
	public List<ShowHotel> findAllList() {
		return dao.findAllList(new ShowHotel());
	}
	
}