package com.cku.oa.order.service.impl;

import com.cku.oa.common.SysBusinessIdConstants;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.vo.DnaArchiveBusinessVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * DNA亲子比对处理类
 *
 * @author yuanshuai
 * @date 2023/6/18 15:19
 */
@Service
public class DnaArchiveOrderServiceImpl extends BaseSkuBusinessService<DnaArchiveBusinessVo> {

    @Autowired
    private DogBloodSaveService dogBloodSaveService;
    @Autowired
    private DogDnaArchiveService dogDnaArchiveService;


    @Override
    @Transactional(readOnly = false)
    public void processBusinessPrePay(OrderApplyRequest orderRequest, DnaArchiveBusinessVo businessData, OrderSkuVo skuVo) {
        //根据不同业务处理入口
        if (SysBusinessIdConstants.GOLD_CERTIFIED.equals(orderRequest.getBusinessID())) {
            //处理金质证书
            processBusinessByGoldCertified(businessData, skuVo);
        }
    }

    /**
     * 根据金质证书处理业务
     *
     * @author yuanshuai
     * @date 2023/6/20 16:30
     */
	private void processBusinessByGoldCertified(DnaArchiveBusinessVo businessData, OrderSkuVo skuVo) {
		//位点分析
		DogDnaArchive dogDnaArchive = buildDnaArchiveByGoldCertified(businessData, skuVo);
		dogDnaArchiveService.save(dogDnaArchive);
		//血样留存
		//判断是否有血样留存
		Boolean nullFlag = Boolean.TRUE;
		if (StringUtils.isNotBlank(businessData.getPedigreeCertified())) {
			DogBloodSave bloodSave = dogBloodSaveService.getByPedigreeCertifiedCode(businessData.getPedigreeCertified());
			if (Objects.nonNull(bloodSave)) {
				nullFlag = Boolean.FALSE;
			}
		}
		if (StringUtils.isNotBlank(businessData.getBirthCode())) {
			DogBloodSave bloodSave = dogBloodSaveService.getByBirthCode(businessData.getBirthCode());
			if (Objects.nonNull(bloodSave)) {
				nullFlag = Boolean.FALSE;
			}
		} else if (StringUtils.isNotBlank(businessData.getOverseasPedigreeCertified())) {
			DogBloodSave bloodSave = dogBloodSaveService.getByOverPedigreeCode(businessData.getOverseasPedigreeCertified());
			if (Objects.nonNull(bloodSave)) {
				nullFlag = Boolean.FALSE;
			}
		}
		if (nullFlag) {
			DogBloodSave dogBloodSave = buildBloodSaveByGoldCertified(businessData, skuVo);
			dogBloodSaveService.save(dogBloodSave);
		}
	}

    /**
     * 根据金质证书构建位点分析
     *
     * @author yuanshuai
     * @date 2023/6/20 17:00
     */
    private static DogDnaArchive buildDnaArchiveByGoldCertified(DnaArchiveBusinessVo businessData, OrderSkuVo skuVo) {
        DogDnaArchive dogDnaArchive = new DogDnaArchive();
        dogDnaArchive.setDogId(businessData.getDogId());
        dogDnaArchive.setPedigreeCertified(businessData.getPedigreeCertified());
        dogDnaArchive.setBirthCode(businessData.getBirthCode());
        dogDnaArchive.setPaymentMemberCode(skuVo.getMember().getMemberCode());
		dogDnaArchive.setApplyChannel(businessData.getDnaApplyChannel());
		//机构办理写入机构ID
		if (0 == businessData.getDnaApplyChannel()) {
			dogDnaArchive.setOrgId(businessData.getHospitalId());
		}
        // 是否为口腔上皮细胞测试法:否0；是1
        dogDnaArchive.setIsOEC("1");
        dogDnaArchive.setRunningNumber(skuVo.getOrderCode());
        dogDnaArchive.setPrice(skuVo.getUnitPrice().toString());
        dogDnaArchive.setReviewState("0");
        dogDnaArchive.setPaymentState("1");
        dogDnaArchive.setProcessState("0");
        dogDnaArchive.setPrintState("0");
        return dogDnaArchive;
    }

    /**
     * 根据金质证书构建血样留存
     *
     * @author yuanshuai
     * @date 2023/6/20 17:00
     */
    private static DogBloodSave buildBloodSaveByGoldCertified(DnaArchiveBusinessVo businessData, OrderSkuVo skuVo) {
        DogBloodSave dogBloodSave = new DogBloodSave();
        dogBloodSave.setPedigreeCertified(businessData.getPedigreeCertified());
        dogBloodSave.setBirthCode(businessData.getBirthCode());
        dogBloodSave.setPaymentMemberCode(skuVo.getMember().getMemberCode());
		//机构办理写入机构ID
		if (0 == businessData.getDnaApplyChannel()) {
			dogBloodSave.setOrgId(businessData.getHospitalId());
		}
        // 是否为口腔上皮细胞测试法:否0；是1
        dogBloodSave.setIsOEC("1");
        dogBloodSave.setRunningNumber(skuVo.getOrderCode());
        dogBloodSave.setPrice(BigDecimal.ZERO.toString());
        dogBloodSave.setPaymentState("1");
        return dogBloodSave;
    }

}
