package com.cku.oa.handler.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.handler.entity.RefereeRankingSchem;
import com.cku.oa.handler.service.RefereeRankingSchemService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 牵犬师积分方案Controller
 * 
 * @author zxy
 * @version 2023-06-05
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/refereeRankingSchem")
public class RefereeRankingSchemController extends BaseController {

	@Autowired
	private RefereeRankingSchemService refereeRankingSchemService;

	@ModelAttribute
	public RefereeRankingSchem get(@RequestParam(required = false) String id) {
		RefereeRankingSchem entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = refereeRankingSchemService.get(id);
		}
		if (entity == null) {
			entity = new RefereeRankingSchem();
		}
		return entity;
	}

	@RequiresPermissions("handler:refereeRankingSchem:view")
	@RequestMapping(value = { "list", "" })
	public String list(RefereeRankingSchem refereeRankingSchem, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<RefereeRankingSchem> page = refereeRankingSchemService
				.findPage(new Page<RefereeRankingSchem>(request, response), refereeRankingSchem);
		model.addAttribute("page", page);
		List<String> yearList = refereeRankingSchemService.getAllYear();
		List<String> monthList = refereeRankingSchemService.getAllMonth();
		model.addAttribute("yearList", yearList);
		model.addAttribute("monthList", monthList);
		return "oa/handler/refereeRankingSchemList";
	}

	@RequiresPermissions("handler:refereeRankingSchem:view")
	@RequestMapping(value = "form")
	public String form(RefereeRankingSchem refereeRankingSchem, Model model) {
		model.addAttribute("refereeRankingSchem", refereeRankingSchem);
		model.addAttribute("typeList", DictUtils.getDictList("referee_schem_type"));
		return "oa/handler/refereeRankingSchemForm";
	}

	@RequiresPermissions("handler:refereeRankingSchem:edit")
	@RequestMapping(value = "save")
	public String save(RefereeRankingSchem refereeRankingSchem, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, refereeRankingSchem)) {
			return form(refereeRankingSchem, model);
		}
		refereeRankingSchemService.saveSchem(refereeRankingSchem);
		addMessage(redirectAttributes, "保存方案成功");
		return "redirect:" + Global.getAdminPath() + "/handler/refereeRankingSchem/?repage";

	}

	@RequiresPermissions("handler:refereeRankingSchem:edit")
	@RequestMapping(value = "delete")
	public String delete(RefereeRankingSchem refereeRankingSchem, RedirectAttributes redirectAttributes) {
		refereeRankingSchemService.delete(refereeRankingSchem);
		addMessage(redirectAttributes, "删除方案成功");
		return "redirect:" + Global.getAdminPath() + "/handler/refereeRankingSchem/?repage";
	}

	@RequestMapping(value = "create")
	@ResponseBody
	public void create(HttpServletRequest request) {
		String id = request.getParameter("id");
		refereeRankingSchemService.create(id);
	}

	@RequestMapping(value = "updateStatus")
	@ResponseBody
	public Map<String, String> updateStatus(HttpServletRequest request) {
		String id = request.getParameter("id");
		int row = refereeRankingSchemService.updateStatus(id, "1");
		Map<String, String> resultMap = new HashMap<>();
		resultMap.put("data", row > 0 ? "OK" : "ERROR");
		return resultMap;
	}

	@RequestMapping(value = "schemCheck")
	@ResponseBody
	public Map<String, String> schemCheck(HttpServletRequest request) {
		String year = request.getParameter("year");
		String quarter = request.getParameter("quarter");
		String month = request.getParameter("month");
		String type = request.getParameter("type");
		String half = request.getParameter("half");
		RefereeRankingSchem refereeRankingSchem = new RefereeRankingSchem();
		refereeRankingSchem.setYear(year);
		refereeRankingSchem.setQuarter(quarter);
		refereeRankingSchem.setMonth(month);
		refereeRankingSchem.setType(type);
		refereeRankingSchem.setHalf(half);
		return refereeRankingSchemService.schemCheck(refereeRankingSchem);
	}

}
