package com.cku.oa.gcWeb.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.gcWeb.entity.GCWebFooter;
import com.cku.oa.gcWeb.service.GCWebFooterService;

/**
 * 美容官网底部信息Controller
 * @author yuanshuai
 * @version 2023-01-29
 */
@Controller
@RequestMapping(value = "${adminPath}/gcWeb/footer")
public class GCWebFooterController extends BaseController {

	@Autowired
	private GCWebFooterService gcWebFooterService;
	
	@ModelAttribute
	public GCWebFooter get(@RequestParam(required=false) String id) {
		GCWebFooter entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = gcWebFooterService.get(id);
		}
		if (entity == null){
			entity = new GCWebFooter();
		}
		return entity;
	}
	
	@RequiresPermissions("gcWeb:footer:view")
	@RequestMapping(value = {"list", ""})
	public String list(GCWebFooter gcWebFooter, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GCWebFooter> page = gcWebFooterService.findPage(new Page<>(request, response), gcWebFooter);
		model.addAttribute("page", page);
		model.addAttribute("gcWebFooter", gcWebFooter);
		return "oa/gcWeb/gcWebFooterList";
	}

	@RequiresPermissions("gcWeb:footer:view")
	@RequestMapping(value = "form")
	public String form(GCWebFooter gcWebFooter, Model model) {
		model.addAttribute("gcWebFooter", gcWebFooter);
		return "oa/gcWeb/gcWebFooterForm";
	}

	@RequiresPermissions("gcWeb:footer:edit")
	@RequestMapping(value = "save")
	public String save(GCWebFooter gcWebFooter, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, gcWebFooter)){
			return form(gcWebFooter, model);
		}
		gcWebFooterService.save(gcWebFooter);
		addMessage(redirectAttributes, "保存美容官网底部信息成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/footer/?repage";
	}
	
	@RequiresPermissions("gcWeb:footer:del")
	@RequestMapping(value = "delete")
	public String delete(GCWebFooter gcWebFooter, RedirectAttributes redirectAttributes) {
		gcWebFooterService.delete(gcWebFooter);
		addMessage(redirectAttributes, "删除美容官网底部信息成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/footer/?repage";
	}

}