/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogDnaParentsCompareAudit;
import com.cku.oa.dog.vo.DogDnaParentsCompareAuditVO;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * DNA双亲比对审核表DAO接口
 * 
 * @author xx
 * @version 2024-04-25
 */
@MyBatisDao
public interface DogDnaParentsCompareAuditDao extends CrudDao<DogDnaParentsCompareAudit> {

	List<DogDnaParentsCompareAuditVO> findPageFC(DogDnaParentsCompareAuditVO entity);
	
	DogDnaParentsCompareAuditVO getByIdFC(@Param("id") String id);
	
	int updateAuditById(DogDnaParentsCompareAudit entity);
	
	DogDnaParentsCompareAuditVO getByCompareId(@Param("dogDnaParentsCompareId") String dogDnaParentsCompareId);
	
	List<DogDnaParentsCompareAuditVO> findByOrderCodes(@Param("orderCodes") List<String> orderCodes);
	
	DogDnaParentsCompareAuditVO findByOrderCode(@Param("orderCode") String orderCode);

}