<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬主变更申请管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
            $(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogOwnerChange">犬主变更申请列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogOwnerChange" action="${ctxDc}/dogOwnerChange" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
		    <li><label>血统证书号：</label>
                <form:input path="dog.pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>会员号/姓名：</label>
				<form:input path="originOwnerName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核人：</label>
				<form:input path="reviewer" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>付款状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>处理状态：</label>
                <form:select path="processState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>申请时间：</label>
				<input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogOwnerChange.beginDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--
					<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogOwnerChange.endDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>审核时间：</label>
                <input name="reviewBeginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogOwnerChange.reviewBeginDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--
                    <input name="reviewEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogOwnerChange.reviewEndDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			    <th>血统证书号</th>
				<th>原犬主姓名</th>
				<th>新犬主姓名</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>缴费时间</th>
				<th>审核状态</th>
				<th>审核日期</th>
				<th>审核人</th>
				<th>处理状态</th>
				<th>查看</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogOwnerChange">
			<tr>
			    <td>
			        ${fns:escapeHtml(dogOwnerChange.dog.pedigreeCertifiedCode) }
			    </td>
				<td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.originOwnerMemberCode) }">
					${fns:escapeHtml(dogOwnerChange.originOwnerName) }
				</td >
				<td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.newOwnerMemberCode) }">
					${fns:escapeHtml(dogOwnerChange.newOwnerName) }
				</td>
				<td>
                    <fmt:formatDate value="${dogOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    <c:if test="${dogOwnerChange.paymentState==1}"><font color="red">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font></c:if>
                    <c:if test="${dogOwnerChange.paymentState==2}"><font color="green">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font></c:if>
                </td>
                <td>
                    <fmt:formatDate value="${dogOwnerChange.paymentTime}" pattern="yyyy-MM-dd"/>
                </td>
                <td title="${fns:escapeHtml(dogOwnerChange.reviewRemarks) }">
	                        ${fns:getDictLabel(dogOwnerChange.reviewState, 'review_state', '')}
                </td>
                <td>
                    <fmt:formatDate value="${dogOwnerChange.reviewTime}" pattern="yyyy-MM-dd"/>
                </td>
				<td><c:if test="${dogOwnerChange.reviewState!='0'}">
					${fns:escapeHtml(dogOwnerChange.reviewer) }
					</c:if>
				</td>
				<td>
				    ${fns:getDictLabel(dogOwnerChange.processState, 'proccess_state', '')}
				</td>
				<td>
				<a href="${ctxDc}/dogOwnerChange/form?id=${dogOwnerChange.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>