<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬种组犬展裁判证书表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/">犬种组犬展裁判证书表列表</a></li>
    <li class="active"><a
            href="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/form?id=${showJudgeCertificateDogGroup.id}">犬种组犬展裁判证书表<shiro:hasPermission
            name="judgecertificatedoggroup:showJudgeCertificateDogGroup:edit">${not empty showJudgeCertificateDogGroup.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="judgecertificatedoggroup:showJudgeCertificateDogGroup:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="showJudgeCertificateDogGroup"
           action="${ctx}/judgecertificatedoggroup/showJudgeCertificateDogGroup/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">主裁判证书号：</label>
        <div class="controls">
            <form:input path="judgeCertificateMian" htmlEscape="false" maxlength="20" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">裁判证书号：</label>
        <div class="controls">
            <form:input path="judgeCertificate" htmlEscape="false" maxlength="20" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">签发日期：</label>
        <div class="controls">
            <input name="signDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${showJudgeCertificateDogGroup.signDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">结束日期：</label>
        <div class="controls">
            <input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${showJudgeCertificateDogGroup.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">组别编号：</label>
        <div class="controls">
            <form:input path="groupNo" htmlEscape="false" maxlength="2" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否可见。0不可见；1可见：</label>
        <div class="controls">
            <form:input path="visibleFlag" htmlEscape="false" maxlength="1" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="1024" class="input-xxlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="judgecertificatedoggroup:showJudgeCertificateDogGroup:edit"><input id="btnSubmit"
                                                                                                      class="btn btn-primary"
                                                                                                      type="submit"
                                                                                                      value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>