<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>采样包管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//初始化
			//是否只读
			let isView = '${isView}';
			if (isView == 1) {
				$('#btnSubmit').hide();
				$('#inputForm input').attr('disabled','true');
				$('#inputForm select').attr('disabled','true');
				$('#inputForm textarea').attr('disabled','true');
				$('#inputForm input').unbind();
				$('#btnCancel').removeAttr('disabled');
			}

			//表单
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sampling/sampling/">采样包列表</a></li>
		<li class="active">
			<c:choose>
				<c:when test="${not empty sampling.id and isView == 1}">
					<a href="${ctx}/sampling/sampling/viewForm?id=${sampling.id}">采样包查看</a>
				</c:when>
				<c:when test="${not empty sampling.id and isView == 0}">
					<a href="${ctx}/sampling/sampling/editForm?id=${sampling.id}">采样包修改</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/sampling/sampling/editForm?id=${sampling.id}">采样包添加</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul>
	<br/>
	<form:form id="inputForm" modelAttribute="sampling" action="${ctx}/sampling/sampling/update" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">采样包编号：</label>
			<div class="controls">
				<form:input path="samplingCode" htmlEscape="false" maxlength="32" class="input-xlarge required" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只编号：</label>
			<div class="controls">
				<form:input path="dogCode" htmlEscape="false" maxlength="64" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">归属人：</label>
			<div class="controls">
				<form:input path="memberName" htmlEscape="false" maxlength="16" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">归属人会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="16" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">绑定人：</label>
			<div class="controls">
				<form:input path="bindUserName" htmlEscape="false" maxlength="32" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">绑定人会员号：</label>
			<div class="controls">
				<form:input path="bindMemberCode" htmlEscape="false" maxlength="32" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">绑定时间：</label>
			<div class="controls">
				<input name="bindTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${sampling.bindTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">送检时间：</label>
			<div class="controls">
				<input name="sendTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${sampling.sendTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">状态：</label>
			<div class="controls">
				<c:choose>
					<c:when test="${sampling.flowState < 2}">
						${fns:getDictLabel(sampling.bindType, 'bind_type', '')}
					</c:when>
					<c:otherwise>
						${fns:getDictLabel(sampling.flowState, 'sampling_flow_state', '')}
					</c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="sampling:sampling:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>