<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>藏獒犬只鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			if($("#reviewState").val()==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
            }
		});
		function changeState(val){
            if(val==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
                $("#reviewRemarks").val('');
            }
        }
		function save(){
            $.ajax({
                type: "POST",
                url:"${ctx}/dogtibetanmastiff/dogTibetanMastiff/changeStatus",
                dataType:"json",
                data:$('#inputForm').serialize(),
                async: false,
                error: function(request, textStatus, errorThrown) {
                    alert("系统错误，请联系管理员！");
                },
                success: function(data) {
                    if(data.rc==0){
                        alert("审核成功");
                        parent.isYes = true;
                        parent.layer.closeAll();
                    }else {
                        alert("错误代码："+data.rc+"错误信息："+data.msg);
                        parent.isYes = false;
                        parent.layer.closeAll();
                    }
                }
            });
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/">藏獒犬只鉴定列表</a></li>
		<li class="active"><a href="${ctx}/dogtibetanmastiff/dogTibetanMastiff/audit?id=${dogTibetanMastiff.id}">藏獒犬只鉴定<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:audit">${not empty dogTibetanMastiff.id?'审核':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogtibetanmastiff:dogTibetanMastiff:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogTibetanMastiff" action="${ctx}/dogtibetanmastiff/dogTibetanMastiff/changeStatus" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">犬主姓名：</label>
			<div class="controls">
				<form:input path="dogOwner" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只名称：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬只性别：</label>
            <div class="controls">
                <form:radiobuttons path="gender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" disabled="true"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">犬只生日：</label>
			<div class="controls">
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogTibetanMastiff.birthdate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});" disabled="disabled"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只毛色：</label>
			<div class="controls">
				<form:input path="colorFlag" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">备注信息：</label>
            <div class="controls">
                <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">审核状态：</label>
            <div class="controls">
                <form:select path="reviewState" class="input-xlarge " onclick="changeState(this.value)">
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group" id="reviewDiv">
            <label class="control-label">审核意见：</label>
            <div class="controls">
                <form:textarea path="reviewRemarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
            </div>
        </div>
		<div class="form-actions">
		<shiro:hasPermission name="dogtibetanmastiff:dogTibetanMastiff:audit"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" onclick="save()"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
		 <div style="height:70px;"></div>
	</form:form>
</body>
</html>