<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>第二繁殖人管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dog/dogSecondBreeder/">第二繁殖人列表</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogSecondBreeder" action="${ctx}/dog/dogSecondBreeder/saveReview" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">配种证明编号：</label>
			<div class="controls">
				${dogSecondBreeder.breedCertifiedCode}
			</div>
		</div>
		<div style="width: 100%">
			<table id="contentTable" class="table table-striped table-bordered table-condensed">
				<thead>
				<tr>
					<th>血统证书编号</th>
					<th>登记卡编号</th>
					<th>品种</th>
					<th>犬名</th>
					<th>繁殖人</th>
					<th>犬主人</th>
				</tr>
				</thead>
				<tbody>
					<c:forEach items="${dogBirthCertificateList}" var="dogBirthCertificate">
						<tr>
							<td>
								${dogBirthCertificate.pedigreeCertified}
							</td>
							<td>
								${dogBirthCertificate.birthCerRegCode}
							</td>
							<td>
								${dogBirthCertificate.dogBreed}
							</td>
							<td>
								${dogBirthCertificate.dogEnName}
							</td>
							<td>
								${dogBirthCertificate.breeder}
							</td>
							<td>
								${dogBirthCertificate.dogOwenr}
							</td>
						</tr>
					</c:forEach>
				</tbody>
			</table>
		</div>
		<div class="control-group">
			<label class="control-label">第二繁殖人：</label>
		</div>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
					${dogSecondBreeder.secondBreeder}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
					${dogSecondBreeder.secondBreederMemberCode}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员类型：</label>
			<div class="controls">
					${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员状态：</label>
			<div class="controls">
				<c:if test="${member.states=='0' || empty member.states}">
					<font style="color:green">无效</font>
				</c:if>
				<c:if test="${member.states=='1' }">
					<font style="color:red">有效</font>
				</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核意见：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">添加时间：</label>
			<div class="controls">
				<fmt:formatDate value="${dogSecondBreeder.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dog:dogSecondBreeder:review"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>

			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>