<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/birthcertificate/dogBirthCertificate/list?dogBreed=230">出生证明管理</a></li>
		<shiro:hasPermission name="birthcertificate:dogBirthCertificate:edit">
		</shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogBirthCertificate" action="${ctx}/birthcertificate/dogBirthCertificate/" method="post" class="breadcrumb form-search">
		<input name="dogBreed" type="hidden" value="230"/>
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>出生证明编号：</label>
				<form:input path="birthCerRegCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>配种证明编号：</label>
				<form:input path="fmdogBreedCertifiedCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬主/繁殖人：</label>
				<form:input path="dogOwenr" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>付款的状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_birth_certificate_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>加急状态：</label>
				<form:select path="urgent" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('urgent_status')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>区域：</label>
                <form:select path="agency" class="input-medium">
                	<form:option value="" label="全部"/>
                	<form:options items="${agencyList}" itemLabel="name" itemValue="id" htmlEscape="false"/>
                </form:select>
			</li>
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生证明编号</th>
				<th>配种证明编号</th>
				<th>性别</th>
				<th>英文犬名</th>
				<th>犬种代码</th>
				<th>出生日期</th>
				<th>芯片号码</th>
				<th>犬主人</th>
				<th>加急</th>
				<th>缴费</th>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:audit"><th>审核</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print"><th>打印</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:view"><th>管理</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:delete"><th>删除</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.fmdogBreedCertifiedCode)}
				</td>
				<td>
					${fns:getDictLabel(dogBirthCertificate.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogEnName)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogBreed)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.identificationFlag)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogOwenr)}
				</td>
				<td style="color:${dogBirthCertificate.urgent=='1'?'#F00':''}">
					${fns:getDictLabel(dogBirthCertificate.urgent, 'urgent_status', '')}
				</td>
				<td style="color:${dogBirthCertificate.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogBirthCertificate.paymentState, 'user_payment_state', '未缴费')}
					<c:if test="${dogBirthCertificate.paymentState=='2'}">
						<fmt:formatDate value="${dogBirthCertificate.paymentTime}" pattern="yyyy-MM-dd"/>
					</c:if>
				</td>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:audit">
				<td style="color:#000">
					<c:if test="${dogBirthCertificate.paymentState=='2' and !dogBirthCertificate.businessRefundState}">
					<c:choose>
						<c:when test="${dogBirthCertificate.reviewState=='0'}">
							<a style="color:#F00" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogBirthCertificate.reviewState=='2'}">
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:otherwise>
					</c:choose>
					</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print">
				<td>
					<c:if test="${dogBirthCertificate.paymentState=='2'&&dogBirthCertificate.reviewState=='1' &&!dogBirthCertificate.businessRefundState}">
						<c:if test="${dogBirthCertificate.printType=='0'||dogBirthCertificate.printType=='1'}">
	    					<a href="${ctx}/birthcertificate/dogBirthCertificate/print?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印吗？', this.href)">
	    					${fns:getDictLabel(dogBirthCertificate.printType, 'birth_certificate_print_type', '')}</a>
						</c:if>
						<c:if test="${dogBirthCertificate.printType=='9'}">
	    					<a href="${ctx}/birthcertificate/dogBirthCertificate/resetPrint?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印重置吗？', this.href)">
	    					${fns:getDictLabel(dogBirthCertificate.printType, 'birth_certificate_print_type', '')}</a>
						</c:if>
					</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:view">
				<td>
    				<a href="${ctx}/birthcertificate/dogBirthCertificate/form?id=${dogBirthCertificate.id}">查看</a>
    				<c:if test="${!dogBirthCertificate.businessRefundState}">
    					<a href="${ctx}/birthcertificate/dogBirthCertificate/editForm?id=${dogBirthCertificate.id}">编辑</a>
    				</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:delete">
    			<td>
    				<c:if test="${!dogBirthCertificate.businessRefundState}">
					<a href="${ctx}/birthcertificate/dogBirthCertificate/delete?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要删除该出生证明吗？', this.href)">删除</a>
				</c:if>
			</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>