package com.ufida.api.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

import com.alibaba.fastjson.annotation.JSONField;

public class CashFlowVo implements Serializable {
	
	@JSONField(name = "cash_item")
	private String cashItem = "01";
	
	@JSONField(name = "natural_debit_currency")
	private BigDecimal naturalDebitCurrency;
	
	@JSONField(name = "cCashItem")
	private String ccashItem = "01";
	
	@JSONField(name = "dbill_date",format = "yyyy-MM-dd")
	private Date dbillDate;
	
	@JSONField(name = "csign")
	private String csign = "记";
	
	@JSONField(name = "iyear")
	private String iyear;
	
	@JSONField(name = "iYPeriod")
	private String iyPeriod;
	
	@JSONField(name = "RowGuid")
	private String rowGuid;

	public CashFlowVo(BigDecimal naturalDebitCurrency, Date dbillDate, String iyear, String iyPeriod) {
		this.naturalDebitCurrency = naturalDebitCurrency;
		this.dbillDate = dbillDate;
		this.iyear = iyear;
		this.iyPeriod = iyPeriod;
		this.rowGuid = UUID.randomUUID().toString().replaceAll("-","");
	}

	public String getCashItem() {
		return cashItem;
	}

	public void setCashItem(String cashItem) {
		this.cashItem = cashItem;
	}

	public BigDecimal getNaturalDebitCurrency() {
		return naturalDebitCurrency;
	}

	public void setNaturalDebitCurrency(BigDecimal naturalDebitCurrency) {
		this.naturalDebitCurrency = naturalDebitCurrency;
	}

	public String getCcashItem() {
		return ccashItem;
	}

	public void setCcashItem(String ccashItem) {
		this.ccashItem = ccashItem;
	}

	public Date getDbillDate() {
		return dbillDate;
	}

	public void setDbillDate(Date dbillDate) {
		this.dbillDate = dbillDate;
	}

	public String getCsign() {
		return csign;
	}

	public void setCsign(String csign) {
		this.csign = csign;
	}

	public String getIyear() {
		return iyear;
	}

	public void setIyear(String iyear) {
		this.iyear = iyear;
	}

	public String getIyPeriod() {
		return iyPeriod;
	}

	public void setIyPeriod(String iyPeriod) {
		this.iyPeriod = iyPeriod;
	}

	public String getRowGuid() {
		return rowGuid;
	}

	public void setRowGuid(String rowGuid) {
		this.rowGuid = rowGuid;
	}

}
