package com.cku.schools.sys.interceptor;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 安全拦截器 1.用户是否登录，是否是会员的判断 2.用户
 * 
 * @author fanhuibin
 */
public class LoginInterceptor implements HandlerInterceptor {

	@Override
	public void afterCompletion(HttpServletRequest arg0,
			HttpServletResponse arg1, Object arg2, Exception arg3)
			throws Exception {

	}

	
	@Override
	public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1,
			Object arg2, ModelAndView arg3) throws Exception {
		
		
	}

	/**
	 * 合作学校的接口拦截器
	 */
	@Override
	public boolean preHandle(HttpServletRequest request,
			HttpServletResponse response, Object arg2) throws Exception {
		// 判断用户的登录信息
		User user = UserUtils.getLoginUser();
		if(user == null || user.getId() == null){
			if (request.getHeader("x-requested-with")!= null && request.getHeader("x-requested-with").equalsIgnoreCase("XMLHttpRequest")){//如果是ajax请求响应头会有x-requested-with 
              ServletOutputStream outputStream = response.getOutputStream();
              outputStream.print("{\"rc\":-1}");//返回给前端页面的未登陆标识
              outputStream.flush();
              outputStream.close();
              return false;
			}else{
                response.sendRedirect("/oa-web/schools/login");
                return false;
            }
		}
		return true;
	}

}
