package com.cku.restful.v2.show.web;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowScoreDao;
import com.cku.oa.show.entity.ShowScore;
import com.cku.restful.v1.show.model.CkuShowScore;
import com.cku.restful.v1.show.model.RestMainShows;
import com.cku.restful.v1.show.service.CkuShowsService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * <p>
 * Title:RestShowsController
 * </p>
 * <p>
 * Description: CKU官网赛事部分接口
 * </p>
 * <p>
 * Company:
 * </p>
 *
 * @author zhuoHeng
 * @date 2016年9月23日 上午10:15:42
 */
@Controller
@RequestMapping(value = "/cku/v2/shows")
public class CkuShowsControllerV2 extends BaseRestController {

	@Autowired
	public CkuShowsService restShowsService;
	@Autowired
	private ShowScoreDao showScoreDao;

	/**
	 *
	 * @Description：按报名截止时间倒叙查询近期3场赛事（CKU官网快速报名通道使用）
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 上午10:18:45
	 * @throws IOException
	 */
	@RequestMapping(value = "/shows", method = RequestMethod.GET)
	@ResponseBody
	public void getShows(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = null;
		try {
			List<RestMainShows> mainShowsList = restShowsService.getMainShows();
			result = new RESTResponse("list",
					new PageBeanResult<RestMainShows>(mainShowsList,
							(long) mainShowsList.size()));
		} catch (Exception e) {
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 全犬种1.按照积分排序查询积分 2.按照血统证书、类型查询、年份查询，可设置显示条数或者不限制 3.不需要分页
	 * @author: laiguanglong
	 * @date: 2016年9月25日 下午5:19:52
	 */
	@RequestMapping(value = "/score/rank", method = RequestMethod.GET)
	@ResponseBody
	public void getScore(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String pageSize = request.getParameter("pageSize");
		String pageNo = request.getParameter("pageNo");
		Integer pageSizeInt = null;
		Integer pageNoInt = null;
		if (StringUtils.isBlank(year) && !scoreType.equals("bbe")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年份为空");
		}
		if (StringUtils.isNotBlank(pageSize)) {
			try {
				pageSizeInt = Integer.valueOf(pageSize);
				pageNoInt = ( Integer.valueOf(pageNo) - 1) * pageSizeInt ;
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"pageSize必须为整数");
			}
		}
		String ageGroup = getAgeGroup(year, scoreType);
		List<ShowScore> showScoreList = null;
		if (StringUtils.isBlank(scoreType) || "1".equals(scoreType)
				|| "2".equals(scoreType) || "3".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank123(year, scoreType,
					pedigreeCertified, pageSizeInt, ageGroup, null);
		} else if ("20".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank20(year, scoreType,
					pedigreeCertified,pageSizeInt, null);
		} else if ("30".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank30(year, scoreType,
					pedigreeCertified, pageSizeInt, ageGroup);
		} else if ("4".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank4(year, scoreType,
					pedigreeCertified, pageSizeInt, ageGroup);
		} else if ("6".equals(scoreType) || "7".equals(scoreType)
				|| "8".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank678(year, scoreType,
					pedigreeCertified, pageSizeInt, ageGroup);
		}
		List<CkuShowScore> list = new ArrayList<CkuShowScore>();
		if (showScoreList != null && showScoreList.size() > 0) {
			for (ShowScore showScore : showScoreList) {
				list.add(new CkuShowScore(showScore));
			}
		}
		long count = list.size();
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<CkuShowScore>(list, count)));
	}

	private String getAgeGroup(String year, String scoreType) {
		String result = "";
		if ("2013".equals(year) || "2014".equals(year) || "2015".equals(year)
				|| "2016".equals(year) || "2017".equals(year) || "2018".equals(year)) {
			if ("1".equals(scoreType) || "8".equals(scoreType)) {
				result = "AND age_group IN (1,2)";
			}
			if ("2".equals(scoreType) || "7".equals(scoreType)) {
				result = "AND age_group IN (3,4)";
			}
			if ("3".equals(scoreType) || "6".equals(scoreType)
					|| "20".equals(scoreType) || "30".equals(scoreType)) {
				result = "AND age_group > 4";
			}
		} else {
			if ("1".equals(scoreType)) {
				result = "AND age_group < 5";
			}
			if ("2".equals(scoreType)) {
				result = "AND age_group >4";
			}
		}
		return result;
	}

	/**
	 *
	 * @description: 单独展1.按照积分排序查询积分 2.按照血统证书、类型查询、年份查询，可设置显示条数或者不限制 3.不需要分页
	 * @author: laiguanglong
	 * @date: 2016年9月25日 下午5:19:52
	 */
	@RequestMapping(value = "/score/rankBov", method = RequestMethod.GET)
	@ResponseBody
	public void getScoreBov(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String formatCode = request.getParameter("formatCode");
		if (StringUtils.isBlank(formatCode)) {
			formatCode = "11";
		}
		Integer formatCodeInt = null;
		if (StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年份为空");
		}
		if (StringUtils.isNotBlank(formatCode)) {
			try {
				formatCodeInt = Integer.valueOf(formatCode);
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"formatCode必须为整数");
			}
		}
		List<ShowScore> showScoreList1 = showScoreDao.getScoreRankBov(year,
				"age_group > 4", pedigreeCertified, formatCodeInt);
		List<ShowScore> showScoreList2 = new ArrayList<ShowScore>();
		List<ShowScore> showScoreList3 = new ArrayList<ShowScore>();
		if("1".equals(formatCode)||"2".equals(formatCode)||"3".equals(formatCode)||"4".equals(formatCode)){
			showScoreList2 = showScoreDao.getScoreRankBov(year,
					"age_group IN (3,4)", pedigreeCertified, formatCodeInt);
			showScoreList3 = showScoreDao.getScoreRankBov(year,
					"age_group IN (1,2)", pedigreeCertified, formatCodeInt);
		}else{
			showScoreList2 = showScoreDao.getScoreRankBov(year,
					"age_group <= 4", pedigreeCertified, formatCodeInt);
		}

		List<CkuShowScore> list1 = new ArrayList<CkuShowScore>();
		for (ShowScore showScore : showScoreList1) {
			list1.add(new CkuShowScore(showScore));
		}
		List<CkuShowScore> list2 = new ArrayList<CkuShowScore>();
		for (ShowScore showScore : showScoreList2) {
			list2.add(new CkuShowScore(showScore));
		}
		List<CkuShowScore> list3 = new ArrayList<CkuShowScore>();
		for (ShowScore showScore : showScoreList3) {
			list3.add(new CkuShowScore(showScore));
		}
		JSONObject jo = new JSONObject();
		jo.put("list1", list1);
		jo.put("list2", list2);
		jo.put("list3", list3);
		ServletUtils.writeResponse(response, new RESTResponse(jo));
	}

}
