/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.oa.kennel.service.KennelService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


@Api(tags = "犬舍接口--wj")
@Controller
@RequestMapping(value = "/api/v1/open/kennel")
public class OpenKennelController extends BaseRestController {

    @Autowired
    private KennelService KennelService;


    @ApiOperation(value = "APP犬舍列表")
    @ApiImplicitParams({ @ApiImplicitParam(name = "pageNo",paramType = "query", value = "页码"),
            @ApiImplicitParam(name = "pageSize",paramType = "query", value = "条数"),
            @ApiImplicitParam(name = "name", paramType = "query", value = "名称")})
    @ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
            "  \"rc\": 0,\n" +
            "  \"msg\": \"OK\",\n" +
            "  \"data\": [\n" +
            "    {\n" +
            "      \"owner\": \"刘载春\",\n" +
            "      \"address\": \"北京市北京市\",\n" +
            "      \"star\": \"5\",\n" +
            "      \"name\": \"海润犬舍\",\n" +
            "      \"nameEn\": \"Hai Run's Kennel（FCI）\",\n" +
            "      \"type\": \"永久犬舍\"\n" +
            "    }\n" +
            "  ]\n" +
            "}")})
    @RequestMapping(value = "/kennelList", method = RequestMethod.GET)
    @ResponseBody
    public void kennelList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = KennelService.kennelList(request,response,Boolean.TRUE);
        ServletUtils.writeResponse(response, result);
    }

}