/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.kennel.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.kennel.service.RestKennelService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 犬舍基本信息Controller
 * 
 * @author fanhuibin
 * @version 2016-07-13
 */
@Controller
@RequestMapping(value = "/api/v1/kennel")
public class RestKennelController extends BaseRestController {

	@Autowired
	private RestKennelService restKennelService;

	@RequestMapping(value = "/kennel", method = RequestMethod.GET)
	@ResponseBody
	public void get(HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.get();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 校验犬舍名称
	 * 
	 * @param json
	 * @param response
	 * @throws IOException
	 */

	@ApiOperation(value = "犬舍名称变更-检查重复中英文名称", tags = { "犬舍名称变更-zxy" })
	@ApiImplicitParam(name = "token", paramType = "query", value = "token")
	@ApiResponses({
			@ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
					+ "    \"data\":\"true\"\n" + "}\n" + ""),
			@ApiResponse(code = 1001, message = "{\n" + "    \"rc\":1001,\n" + "    \"msg\":\"犬舍中文名只能是中文\",\n"
					+ "    \"src\":\"za\"\n" + "}\n" + "") })
	@RequestMapping(value = "/checkKennelName", method = RequestMethod.POST)
	@ResponseBody
	public void checkKennelName(
			@ApiParam(name = "json", value = "{\n"
					+ "    \"isCheckType\":\"name-中文名, nameEn-英文名, fciName-fci名 ，fciNameBackup-备用fci名\",   \n"
					+ "    \"nameEn\":\"key根据isCheckType的value\" \n" + "}\n" + "") @RequestBody String json,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.checkKennelName(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/kennel", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/kennel/addCart", method = RequestMethod.GET)
	@ResponseBody
	public void addCart(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.addCart();
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/upgrade", method = RequestMethod.POST)
	@ResponseBody
	public void upgrade(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.upgrade(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/renew", method = RequestMethod.POST)
	@ResponseBody
	public void renew(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.renew(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/kennel", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @Description：犬舍名称校验
	 * @author: zhuoHeng
	 * @version: 2016年12月2日 下午3:56:51
	 */
	@RequestMapping(value = "/kennelValidata", method = RequestMethod.GET)
	@ResponseBody
	public void kennelValidata(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.kennelValidata(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @Description：获取犬舍注册费
	 * @author: zhuoHeng
	 * @version: 2016年12月2日 下午4:20:23
	 */
	@RequestMapping(value = "/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月12日 上午10:41:20
	 */
	@RequestMapping(value = "/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restKennelService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}
}