package com.cku.restful.v1.dog.vo.response;

import com.drew.lang.annotations.NotNull;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanshuai
 * @date 2023/6/8 15:33
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class GoldCertifiedPageResp implements Serializable {
    private static final long serialVersionUID = 4836388045453673375L;

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("申请来源（1：升级2：申请）")
    private String applySource;

    @ApiModelProperty("血统证书号")
    private String pedigreeCertified;

    @ApiModelProperty("出生纸编号")
    private String birthCode;

    @ApiModelProperty(" 身份识别标记")
    private String identificationFlag;

    @ApiModelProperty("英文姓名")
    private String nameEn;

    @ApiModelProperty("呼名")
    private String nickname;

    @ApiModelProperty("犬种")
    private String dogBreed;

    @ApiModelProperty("毛色")
    private String colorFlag;

    @ApiModelProperty("性别")
    private String gender;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("出生日期")
    private Date birthdate;

	@ApiModelProperty(value = "电子证书标记位：0否；1是")
	@NotNull
	private Integer ecertFlag;

    @ApiModelProperty("会员号")
    private String memberCode;

    @ApiModelProperty("犬主人")
    private String memberName;

    @ApiModelProperty("繁育人会员号")
    private String breederMemberCode;

    @ApiModelProperty("繁育人会员号")
    private String breederMemberName;

    @ApiModelProperty("公犬证书号")
    private String malePedigreeCertified;

    @ApiModelProperty("母犬证书号")
    private String femalePedigreeCertified;

    @ApiModelProperty("付款状态")
    private String paymentState;
    
    @ApiModelProperty("退款状态")
    private String isCanceled;

    @ApiModelProperty("审核状态")
    private String reviewState;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("申请时间")
    private Date createDate;

    @ApiModelProperty("审核意见")
    private String reviewRemarks;
    
	@ApiModelProperty("父犬主审核状态 0未审核 1同意 2不同意")
	private String fdogReviewState;

	@ApiModelProperty("母犬主审核状态 0未审核 1同意 2不同意")
	private String mdogReviewState;
	
	@ApiModelProperty("母犬主审核意见")
	private String mdogReviewRemarks;
	
	@ApiModelProperty("父犬主审核意见")
	private String fdogReviewRemarks;
}
