/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogService;
import com.cku.restful.v1.dog.vo.DogMCVO;

/**
 * 犬只信息管理Service
 *
 * @author zhuoHeng
 * @version 2016-07-22
 */
@Service
@Transactional(readOnly = true)
public class RestDogMCService {

	@Autowired
	public DogService dogService;
	@Autowired
	private DogNewbornService dogNewbornService;

	public RESTResponse getChildrenByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		vaildMC(key, source);
		List<DogMCVO> list = new ArrayList<>();
		List<Dog> dogList = dogService.getByParents(key);
		int i = 1;
		for (Dog data : dogList) {
			DogMCVO dogVo = new DogMCVO(data);
			dogVo.setCode(i + "");
			list.add(dogVo);
			i++;
		}
		return new RESTResponse("data", list);
	}

	private Dog vaildMC(String key, String source) {
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		Dog dog = dogService.getByPedigreeCertifiedCode(key);
		if (dog == null) {
			dog = dogService.getByPedigreeCertifiedEn(key);
			if (dog == null) {
				dogService.getByIdentificationFlag(key);
			}
		}
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到该犬只信息");
		}
		if ("ckumc".equals(source)) {
			if (!"15C".equals(dog.getDogBreed()) || !"15C".equals(dog.getDogBreed())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询犬只非玛犬！");
			}
		}
		return dog;
	}

	public RESTResponse getSameBatchDogByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		Dog dog = vaildMC(key, source);
		List<Dog> dogList = dogService.getByFmdogBreedCertifiedCode(dog.getFmdogBreedCertifiedCode());
		List<DogMCVO> list = new ArrayList<>();
		if(!CollectionUtils.isEmpty(dogList)) {
			list.addAll(dogList.stream().map(data->{return new DogMCVO(data);}).collect(Collectors.toList()));
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse getCoupleDogByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		Dog dog = vaildMC(key, source);
		List<DogNewborn> dogNewbornList = dogNewbornService.getDogBreedList(key);
		List<DogMCVO> list = new ArrayList<>();
		for (DogNewborn data : dogNewbornList) {
			DogMCVO dogVo = new DogMCVO(data);
			if (dog.getGender().equals("1")) {
				Dog mdog = dogService.getByPedigreeCertifiedCode(data.getFemalePedigreeCertified());
				dogVo.setIdentificationFlag(mdog.getIdentificationFlag());
				dogVo.setDogOwner(data.getFemaleDogOwner());
				dogVo.setPedigreeCertifiedCode(data.getFemalePedigreeCertified());
			} else {
				Dog fdog = dogService.getByPedigreeCertifiedCode(data.getMalePedigreeCertified());
				dogVo.setIdentificationFlag(fdog.getIdentificationFlag());
				dogVo.setDogOwner(data.getMaleDogOwner());
				dogVo.setPedigreeCertifiedCode(data.getMalePedigreeCertified());
			}
			list.add(dogVo);
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse getSameFatherDogByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		Dog dog = vaildMC(key, source);
		List<DogMCVO> list = new ArrayList<>();
		if(StringUtils.isNotBlank(dog.getMdogPedigreeCertified())) {
			List<Dog> dogList = dogService.getByFatherDog(dog.getMdogPedigreeCertified());
			if(!CollectionUtils.isEmpty(dogList)) {
				for (Dog data : dogList) {
					DogMCVO dogVo = new DogMCVO(data);
					list.add(dogVo);
				}
			}
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse getSameMotherDogByKey(HttpServletRequest request) {
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		Dog dog = vaildMC(key, source);
		List<DogMCVO> list = new ArrayList<>();
		if(StringUtils.isNotBlank(dog.getFdogPedigreeCertified())) {
			List<Dog> dogList = dogService.getByMotherDog(dog.getFdogPedigreeCertified());
			if(!CollectionUtils.isEmpty(dogList)) {
				for (Dog data : dogList) {
					DogMCVO dogVo = new DogMCVO(data);
					list.add(dogVo);
				}
			}
		}
		return new RESTResponse("data", list);
	}
}