package com.cku.oa.sys.web;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.sys.dao.PrintLogsDao;
import com.cku.oa.sys.entity.PrintLogs;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.OrgChip;
import com.cku.oa.sys.service.OrgChipService;
import com.cku.oa.sys.service.OrgService;

/**
 * 芯片发放记录Controller
 * 该功能临时使用，将来要废除的。
 * @author fanhuibin
 * @version 2016-09-06
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/orgChip")
public class OrgChipController extends BaseController {

	@Autowired
	private OrgChipService orgChipService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private PrintLogsDao printLogsDao;
	@ModelAttribute
	public OrgChip get(@RequestParam(required=false) String id) {
		OrgChip entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = orgChipService.get(id);
		}
		if (entity == null){
			entity = new OrgChip();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = {"list", ""})
	public String list(OrgChip orgChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		orgChip.setRemarks(null);
		orgChip.setInvalid(null);
		orgChip.setChipCode(null);
		orgChip.setAddress(null);
		Page<OrgChip> page = orgChipService.findPage(new Page<OrgChip>(request, response), orgChip); 
		model.addAttribute("page", page);
		return "oa/sys/orgChipList";
	}

	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = "form")
	public String form(OrgChip orgChip, Model model) {
		model.addAttribute("orgChip", orgChip);
		return "oa/sys/orgChipForm";
	}
	
	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = "add")
	public String add(OrgChip orgChip, Model model) {
		Org org = orgService.get(orgChip.getOrgId());
		orgChip.setAddress(org.getAddress());
		model.addAttribute("orgChip", orgChip);
		model.addAttribute("org",org);
		model.addAttribute("orgCodePrefix",Global.getConfig("chip.prefix"));
		return "oa/sys/orgChipAdd";
	}
	
	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = "batchSave")
	public String batchSave(OrgChip orgChip, Model model,HttpServletRequest request,HttpServletResponse response,RedirectAttributes redirectAttributes) {
		String[] cardNo = request.getParameterValues("cardNo");
		orgChip.setChipPrefix(request.getParameter("chipPrefix"));
		orgChipService.batchSave(orgChip, cardNo);
		addMessage(redirectAttributes, "保存芯片发放记录成功");
		Org org = orgService.get(orgChip.getOrgId());
		if ("singleTypeClub".equals(org.getOrgType())) {
			return "redirect:" + Global.getAdminPath() + "/sys/singleOrg?repage";
		} else {
			return "redirect:" + Global.getAdminPath() + "/sys/org?repage";
		}
	}
	
	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = "group")
	public String group(OrgChip orgChip, HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = orgService.get(orgChip.getOrgId());
		List<OrgChip> list = orgChipService.getPutOutHistory(orgChip);
		model.addAttribute("list", list);
		model.addAttribute("org",org);
		int printCount=0;
		int printCountDC=0;
		int printCountMC=0;
		//查看打印次数
		List<PrintLogs> logs= printLogsDao.getByPrintCount(org.getUser().getId());
		for(PrintLogs log : logs){
			if(log.getPrintTypeLogs().equals("1")){
				printCountDC=log.getPrintCount();
			}
			if(log.getPrintTypeLogs().equals("2")){
				printCountMC=log.getPrintCount();
			}
			if(log.getPrintTypeLogs().equals("3")){
				printCount=log.getPrintCount();
			}
		}
		model.addAttribute("printCount",printCount);
		model.addAttribute("printCountDC",printCountDC);
		model.addAttribute("printCountMC",printCountMC);
		return "oa/sys/orgChipGroup";
	}

	@RequiresPermissions("sys:org:edit")
	@RequestMapping(value = "save")
	public String save(OrgChip orgChip, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, orgChip)){
			return form(orgChip, model);
		}
		orgChipService.save(orgChip);
		redirectAttributes.addFlashAttribute("orgChip", orgChip);
		addMessage(redirectAttributes, "保存芯片发放记录成功");
		return "redirect:"+Global.getAdminPath()+"/sys/orgChip/?repage";
	}
	
	@RequiresPermissions("sys:org:edit")
	@RequestMapping(value = "delete")
	public String delete(OrgChip orgChip, RedirectAttributes redirectAttributes) {
		String orgId = orgChip.getOrgId();
		Date postDate = orgChip.getPostDate();
		orgChipService.delete(orgChip);
		addMessage(redirectAttributes, "删除芯片发放记录成功");
		return "redirect:"+Global.getAdminPath()+"/sys/orgChip/group?orgId="+orgId+"&postDate="+postDate;
	}
	
	/**
	 * 批量删除功能
	 * @param orgChip
	 * @param redirectAttributes
	 * @user chaixueteng
	 * @date 2017-06-02
	 */
	@RequiresPermissions("sys:org:edit")
	@RequestMapping(value = "deleteList")
	public String deleteList(OrgChip orgChip, RedirectAttributes redirectAttributes) {
		String orgId = orgChip.getOrgId();
		orgChipService.deleteList(orgChip);
		addMessage(redirectAttributes, "删除批量芯片发放记录成功");
		return "redirect:"+Global.getAdminPath()+"/sys/orgChip/group?orgId="+orgId;
	}
	
	/**
	 * 录入的芯片校验重复性
	 * @Author chaixueteng
	 * @2016年10月23日下午2:27:00
	 */
	@RequestMapping("checkChip")
	@ResponseBody
	public Object checkChip(HttpServletRequest request,HttpServletResponse response){
		String chipCode = request.getParameter("chip");
		String id = request.getParameter("id");
		return orgChipService.checkChip(chipCode,id);
	}
}