package com.cku.oa.sys.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.DateUtils;

/**
 * ip每日限额工具类
 * 
 * @author fanhuibin
 */
public class IPLimitUtil {
	private static final String CACHE_NAME = "IPCache";

	/**
	 * 查询是否满足ip限额
	 * 
	 * @param key
	 * @param request
	 * @param count
	 *            允许的次数
	 * @return
	 */
	public static void CheckLimit(String key, HttpServletRequest request,
			int count) {
		String ip = getIpAddr(request);
		CheckLimit(key,ip,count);
	}
	
	public static void CheckLimit(String key ,String ip,int count){
		key = ip+key;
		Integer currentCount = (Integer) CacheUtils.get(CACHE_NAME, key);
		String date = (String) CacheUtils.get(CACHE_NAME, key + "-date");
		Date currentDate = new Date();
		String cDate = DateUtils.formatDate(currentDate, "yyyy-MM-dd");
		if (date!=null && date.equals(cDate)) {
			if (currentCount <= count) {
				currentCount += 1;
				CacheUtils.put(CACHE_NAME, key, currentCount);
			} else {
				throw new ZAException(ZAErrorCode.ZA_ERC_IP_LIMIT,
						"该接口的访问已经达到了ip限制，请明天再访问");
			}
		} else {
			CacheUtils.put(CACHE_NAME, key, 1);
			CacheUtils.put(CACHE_NAME, key + "-date", cDate);
		}
	}

	public static String getIpAddr(HttpServletRequest request) {
		String ipAddress = null;
		// ipAddress = request.getRemoteAddr();
		ipAddress = request.getHeader("x-forwarded-for");
		if (ipAddress == null || ipAddress.length() == 0
				|| "unknown".equalsIgnoreCase(ipAddress)) {
			ipAddress = request.getHeader("Proxy-Client-IP");
		}
		if (ipAddress == null || ipAddress.length() == 0
				|| "unknown".equalsIgnoreCase(ipAddress)) {
			ipAddress = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ipAddress == null || ipAddress.length() == 0
				|| "unknown".equalsIgnoreCase(ipAddress)) {
			ipAddress = request.getRemoteAddr();
			if (ipAddress.equals("127.0.0.1")) {
				// 根据网卡取本机配置的IP
				InetAddress inet = null;
				try {
					inet = InetAddress.getLocalHost();
				} catch (UnknownHostException e) {
					e.printStackTrace();
				}
				ipAddress = inet.getHostAddress();
			}

		}

		// 对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
		if (ipAddress != null && ipAddress.length() > 15) { // "***.***.***.***".length()
															// = 15
			if (ipAddress.indexOf(",") > 0) {
				ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
			}
		}
		return ipAddress;
	}
}
