/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.dao;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.kennel.entity.Kennel;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬舍基本信息DAO接口
 * 
 * @author fanhuibin
 * @version 2016-07-13
 */
@MyBatisDao
public interface KennelDao extends CrudDao<Kennel> {
	int countByName(@Param("key") String key, @Param("value") String value, @Param("memberCode") String memberCode);

	int countCnName(@Param("cnName") String cnName, @Param("memberCode") String memberCode);

	int countEnName(@Param("enName") String enName, @Param("memberCode") String memberCode);

	List<Kennel> getList(int days);

	Kennel getKennelByMemberCode(String memberCode);

	List<Kennel> getKennelByMemberCodes(@Param("memberCodes") List<String> memberCodes);

	Kennel findByKennelCode(@Param("kennelCode") String kennelCode);

	// 得到未审核的 年度犬舍
	int getKennelCount(String reviewState);

	// 得到未审核的 永久犬舍
	int getProfessionalCount(String reviewState);

	// 获取七日内注册的新犬舍
	int getNewKennel(@Param("beginDate") String beginDate);

	void updateKennelRname(Kennel kennel2);

	// 编辑保持犬舍中文名唯一
	List<Kennel> nameCheck(@Param("name") String name);

	// CKU官网根据犬舍名称查询犬舍信息的接口
	Kennel getByName(@Param("name") String name);
	
	// CKU官网和APP首页根据犬舍名称查询犬舍信息的接口
	List<Kennel> pagedSelectByName(Kennel kennel);
	
	// 根据犬舍中文名查询(模糊)
	List<Kennel> getKennel(String name);

	// 根据犬舍英文名查询(模糊)
	List<Kennel> getKennelFci(String name);

	int kennelTypeChange(Kennel kennel);

	int kennelEndDatecharge(Kennel kennel);

	// 获取当前月新注册的犬舍
	int getNewKennelByMouth(@Param("beginTime") Date beginTime, @Param("type") String type);

	// 获取当前月新注册的Fci犬舍
	int getNewFciKennelByMouth(@Param("beginTime") Date beginTime);

	// FCI犬舍导出
	List<Kennel> getFciKennelList(Kennel kennel);

	// 查询当天需要核算的犬舍
	List<Kennel> findKennlCalculationList(@Param("date") Date date);

	void deleteKennelNewRegister(@Param("memberCode") String memberCode);

	// 根据id物理删除新注册未交费(犬舍截至日期为空)的犬舍的记录
	void deleteKennelRegister(@Param("id") String id);

	// 根据id逻辑删除新注册未交费(犬舍截至日期为空)的犬舍的记录
	void logicDeleteKennelRegister(@Param("id") String id);

	// 根据会员号获取标记为已删除的犬舍记录
	Kennel getDeleteRegisterKennelByMemberCode(@Param("memberCode") String memberCode);

	// 获取快过期犬舍
	List<Kennel> getCloseExpireKennel();

	/**
	 * @Description： 导出用犬舍列表
	 * 
	 * @author: yuanshuai
	 * @date: 2019/7/16 16:44
	 */
	List<Kennel> findListForExport();

	int updateKennel(Kennel kennel);
	
	int updateKennelExtra(Kennel kennel);

	int updateKennelEndDate(@Param("memberCode") String memberCode, @Param("kennelEndDate") String kennelEndDate);

	int updateKennelEndDateById(@Param("id") String id, @Param("kennelEndDate") String kennelEndDate);
}