/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容考试题库相关crudEntity
 * @author hjx
 * @version 2023-11-23
 */
public class GroomerExamQuestionBank extends DataEntity<GroomerExamQuestionBank> {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 试卷id
	 */
	private String examPaperId;

	/**
	 * 试卷名称
	 */
	private String examPaperName;

	/**
	 * 考试时长
	 * @return
	 */
	private Integer examDuration;

	/**
	 * 开始考试时间
	 * @return
	 */
	private Date startExamTime;

	/**
	 * 笔试答题信息Id
	 * @return
	 */
	private String writtenInfoId;

	public Integer getExamDuration() {
		return examDuration;
	}

	public void setExamDuration(Integer examDuration) {
		this.examDuration = examDuration;
	}

	public List<GroomerExamQuestions> getGroomerExamQuestionsList() {
		return groomerExamQuestionsList;
	}

	public void setGroomerExamQuestionsList(List<GroomerExamQuestions> groomerExamQuestionsList) {
		this.groomerExamQuestionsList = groomerExamQuestionsList;
	}

	private Integer cosmetologyCertificateLevelId;		// 美容证书级别 1:A、2:B、3:C 详细见枚举CosmetologyCertificateLevelEnum

	private List<GroomerExamQuestions> groomerExamQuestionsList;

	public GroomerExamQuestionBank() {
		super();
	}

	public GroomerExamQuestionBank(String id){
		super(id);
	}

	@Length(min=1, max=4, message="试卷id长度必须介于 1 和 4 之间")
	public String getExamPaperId() {
		return examPaperId;
	}

	public void setExamPaperId(String examPaperId) {
		this.examPaperId = examPaperId;
	}
	
	@Length(min=1, max=128, message="试卷名称长度必须介于 1 和 128 之间")
	public String getExamPaperName() {
		return examPaperName;
	}

	public void setExamPaperName(String examPaperName) {
		this.examPaperName = examPaperName;
	}

	public Integer getCosmetologyCertificateLevelId() {
		return cosmetologyCertificateLevelId;
	}

	public void setCosmetologyCertificateLevelId(Integer cosmetologyCertificateLevelId) {
		this.cosmetologyCertificateLevelId = cosmetologyCertificateLevelId;
	}

	public Date getStartExamTime() {
		return startExamTime;
	}

	public void setStartExamTime(Date startExamTime) {
		this.startExamTime = startExamTime;
	}

	public String getWrittenInfoId() {
		return writtenInfoId;
	}

	public void setWrittenInfoId(String writtenInfoId) {
		this.writtenInfoId = writtenInfoId;
	}
}