package com.cku.oa.finance.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.finance.entity.SaFinanceSubjectMappingItem;
import com.cku.oa.finance.dao.SaFinanceSubjectMappingItemDao;

/**
 * 财务系统映射收费项条目Service
 * @author 财务系统映射收费项条目
 * @version 2019-09-22
 */
@Service
@Transactional(readOnly = true)
public class SaFinanceSubjectMappingItemService extends CrudService<SaFinanceSubjectMappingItemDao, SaFinanceSubjectMappingItem> {

	public SaFinanceSubjectMappingItem get(String id) {
		return super.get(id);
	}
	
	public List<SaFinanceSubjectMappingItem> findList(SaFinanceSubjectMappingItem saFinanceSubjectMappingItem) {
		return super.findList(saFinanceSubjectMappingItem);
	}
	
	public Page<SaFinanceSubjectMappingItem> findPage(Page<SaFinanceSubjectMappingItem> page, SaFinanceSubjectMappingItem saFinanceSubjectMappingItem) {
		return super.findPage(page, saFinanceSubjectMappingItem);
	}
	
	@Transactional(readOnly = false)
	public void save(SaFinanceSubjectMappingItem saFinanceSubjectMappingItem) {
		super.save(saFinanceSubjectMappingItem);
	}
	
	@Transactional(readOnly = false)
	public void delete(SaFinanceSubjectMappingItem saFinanceSubjectMappingItem) {
		super.delete(saFinanceSubjectMappingItem);
	}
	
}