/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import com.thinkgem.jeesite.modules.sys.entity.User;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 充值消费明细Entity
 * @author wangjie
 * @version 2019-08-29
 */
public class SaPaymentDetailTotal extends DataEntity<SaPaymentDetailTotal> {

	private static final long serialVersionUID = 1L;
    @ExcelField(title="会员号", align=2, sort=3)
	private String memberCode;		// 会员号
	private String payMemberCode;		// 付款会员号
	private String chargeGroupId;		// 二级分类
	private String sourceCharge;		// source_charge
    @ExcelField(title="收入归属", align=2, sort=9)
    private String type;		// 类型 cab cku
	private String deptId;		// dept_id
	private String chargeItemId;		// 拆分后收费项
	private Date chargeDate;		// 拆分时间
    @ExcelField(title="流水号", align=2, sort=1)
	private String runningNumber;		// 流水号
	private String orderId;		// orderid
	private String recordId;		// 流水id
    @ExcelField(title="缴费时间", align=2, sort=2)
	private Date paymentTime;		// 付款时间
	@ExcelField(title="支付方式", align=2, sort=8)
	private String paymentWay;		// 付款方式
	private String paymentNum;		// 商品数量
    @ExcelField(title="金额", align=2, sort=10)
	private String price;		// 商品价格
	private String paymentMoney;		// 付款金额
	private Date installmentBeginDate;		// 分期开始时间
	private Date installmentEndDate;		// 分期结束时间
    @ExcelField(title="业务状态", align=2, sort=11)
    private String businessStates;		// 业务状态： 0：未完成，1：已完成
    @ExcelField(title="完成时间", align=2, sort=12)
    private Date finishTime;		// 完成时间
    @ExcelField(title="订单状态", align=2, sort=14)
    private String orderStates;		// 订单状态 ：1:：作废，2：回充，3：退款
    @ExcelField(title="回充原单号", align=2, sort=15)
    private String oldRunningNumber;		// 回充原单号
    @ExcelField(title="余额", align=2, sort=13)
    private String accountBalance;		//
    private String financeVoucherProcessState;		//


    @ExcelField(title="收支类型", align=2, sort=7)
	private String chargingItemName;
	private String chargingItemOfficeId;
    @ExcelField(title="部门", align=2, sort=6)
	private String chargingItemOfficeName;
    @ExcelField(title="付款会员号", align=2, sort=5)
	private String cmember;
	private String orgmember;
    @ExcelField(title="赛事编号", align=2, sort=16)
    private String showCode;
    @ExcelField(title="订单金额", align=2, sort=8)
    private String orderPrice;
	private String paymentTimeStart;
	private String paymentTimeEnd;
//	private String totalMoney;
	private Date finishTimeEnd;
	private Date finishTimeStart;
    @ExcelField(title="姓名", align=2, sort=4)
    private String memberName;
    private User updateByName;		// update_by_name

    private String receiveNum;
    private String ckuName;
    private String cabName;

	public String getCkuName() {
		return ckuName;
	}

	public void setCkuName(String ckuName) {
		this.ckuName = ckuName;
	}

	public String getCabName() {
		return cabName;
	}

	public void setCabName(String cabName) {
		this.cabName = cabName;
	}

	public String getPayMemberCode() {
		return payMemberCode;
	}

	public void setPayMemberCode(String payMemberCode) {
		this.payMemberCode = payMemberCode;
	}

	public String getChargeGroupId() {
		return chargeGroupId;
	}

	public void setChargeGroupId(String chargeGroupId) {
		this.chargeGroupId = chargeGroupId;
	}

	public String getFinanceVoucherProcessState() {
		return financeVoucherProcessState;
	}

	public void setFinanceVoucherProcessState(String financeVoucherProcessState) {
		this.financeVoucherProcessState = financeVoucherProcessState;
	}

//	public String getTotalMoney() {
//		return totalMoney;
//	}
//
//	public void setTotalMoney(String totalMoney) {
//		this.totalMoney = totalMoney;
//	}

	public User getUpdateByName() {
        return updateByName;
    }

    public void setUpdateByName(User updateByName) {
        this.updateByName = updateByName;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getAccountBalance() {
        return accountBalance;
    }

    public void setAccountBalance(String accountBalance) {
        this.accountBalance = accountBalance;
    }

    public String getOrderPrice() {
		return orderPrice;
	}

	public void setOrderPrice(String orderPrice) {
		this.orderPrice = orderPrice;
	}

	public Date getFinishTimeEnd() {
		return finishTimeEnd;
	}

	public void setFinishTimeEnd(Date finishTimeEnd) {
		this.finishTimeEnd = finishTimeEnd;
	}

	public Date getFinishTimeStart() {
		return finishTimeStart;
	}

	public void setFinishTimeStart(Date finishTimeStart) {
		this.finishTimeStart = finishTimeStart;
	}

	public String getPaymentTimeStart() {
		return paymentTimeStart;
	}

	public void setPaymentTimeStart(String paymentTimeStart) {
		this.paymentTimeStart = paymentTimeStart;
	}

	public String getPaymentTimeEnd() {
		return paymentTimeEnd;
	}

	public void setPaymentTimeEnd(String paymentTimeEnd) {
		this.paymentTimeEnd = paymentTimeEnd;
	}

	public String getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(String paymentWay) {
        this.paymentWay = paymentWay;
    }

    public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	public String getChargingItemName() {
		return chargingItemName;
	}

	public void setChargingItemName(String chargingItemName) {
		this.chargingItemName = chargingItemName;
	}

	public String getChargingItemOfficeId() {
		return chargingItemOfficeId;
	}

	public void setChargingItemOfficeId(String chargingItemOfficeId) {
		this.chargingItemOfficeId = chargingItemOfficeId;
	}

	public String getChargingItemOfficeName() {
		return chargingItemOfficeName;
	}

	public void setChargingItemOfficeName(String chargingItemOfficeName) {
		this.chargingItemOfficeName = chargingItemOfficeName;
	}

	public String getCmember() {
		return cmember;
	}

	public void setCmember(String cmember) {
		this.cmember = cmember;
	}

	public String getOrgmember() {
		return orgmember;
	}

	public void setOrgmember(String orgmember) {
		this.orgmember = orgmember;
	}


	public SaPaymentDetailTotal() {
		super();
	}

	public SaPaymentDetailTotal(String id){
		super(id);
	}

	@Length(min=0, max=32, message="会员号长度必须介于 0 和 32 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min=0, max=100, message="source_charge长度必须介于 0 和 100 之间")
	public String getSourceCharge() {
		return sourceCharge;
	}

	public void setSourceCharge(String sourceCharge) {
		this.sourceCharge = sourceCharge;
	}

	@Length(min=0, max=255, message="类型 cab cku长度必须介于 0 和 255 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Length(min=0, max=100, message="dept_id长度必须介于 0 和 100 之间")
	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	@Length(min=0, max=100, message="拆分后收费项长度必须介于 0 和 100 之间")
	public String getChargeItemId() {
		return chargeItemId;
	}

	public void setChargeItemId(String chargeItemId) {
		this.chargeItemId = chargeItemId;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getChargeDate() {
		return chargeDate;
	}

	public void setChargeDate(Date chargeDate) {
		this.chargeDate = chargeDate;
	}

	@Length(min=0, max=255, message="流水号长度必须介于 0 和 255 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=255, message="orderid长度必须介于 0 和 255 之间")
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	@Length(min=0, max=100, message="流水id长度必须介于 0 和 100 之间")
	public String getRecordId() {
		return recordId;
	}

	public void setRecordId(String recordId) {
		this.recordId = recordId;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@Length(min=0, max=11, message="商品数量长度必须介于 0 和 11 之间")
	public String getPaymentNum() {
		return paymentNum;
	}

	public void setPaymentNum(String paymentNum) {
		this.paymentNum = paymentNum;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getPaymentMoney() {
		return paymentMoney;
	}

	public void setPaymentMoney(String paymentMoney) {
		this.paymentMoney = paymentMoney;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getInstallmentBeginDate() {
		return installmentBeginDate;
	}

	public void setInstallmentBeginDate(Date installmentBeginDate) {
		this.installmentBeginDate = installmentBeginDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getInstallmentEndDate() {
		return installmentEndDate;
	}

	public void setInstallmentEndDate(Date installmentEndDate) {
		this.installmentEndDate = installmentEndDate;
	}

	@Length(min=1, max=1, message="业务状态： 0：未完成，1：已完成长度必须介于 1 和 1 之间")
	public String getBusinessStates() {
		return businessStates;
	}

	public void setBusinessStates(String businessStates) {
		this.businessStates = businessStates;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	@Length(min=0, max=1, message="订单状态 ：1:：作废，2：回充，3：退款长度必须介于 0 和 1 之间")
	public String getOrderStates() {
		return orderStates;
	}

	public void setOrderStates(String orderStates) {
		this.orderStates = orderStates;
	}

	@Length(min=0, max=20, message="回充原单号长度必须介于 0 和 20 之间")
	public String getOldRunningNumber() {
		return oldRunningNumber;
	}

	public void setOldRunningNumber(String oldRunningNumber) {
		this.oldRunningNumber = oldRunningNumber;
	}

	public String getReceiveNum() {
		return receiveNum;
	}

	public void setReceiveNum(String receiveNum) {
		this.receiveNum = receiveNum;
	}

}